/*
 * Decompiled with CFR 0.152.
 */
package com.a3ot.eventhorizon.events.subclasses;

import com.a3ot.eventhorizon.data.ModDataComponents;
import com.a3ot.eventhorizon.events.subclasses.AbstractInventoryEvent;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;

public abstract class AbstractEquipmentTransformEvent
extends AbstractInventoryEvent
implements AbstractInventoryEvent.IBasicEvent {
    protected abstract Map<Tier, Tier> getTierMap();

    protected abstract Map<Holder<ArmorMaterial>, Holder<ArmorMaterial>> getMaterialMap();

    protected abstract Map<Tier, String> getTierNames();

    protected abstract Map<Holder<ArmorMaterial>, String> getMaterialNames();

    @Override
    public ItemStack modifyItem(ItemStack stack) {
        if (stack.isEmpty()) {
            return stack;
        }
        Item originalItem = stack.getItem();
        Optional<Object> newItem = Optional.empty();
        if (originalItem instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)originalItem;
            Tier currentTier = tieredItem.getTier();
            Tier nextTier = this.getTierMap().get(currentTier);
            if (nextTier != null) {
                newItem = this.getTransformedItem(originalItem, this.getTierNames().get(nextTier));
            }
        } else if (originalItem instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)originalItem;
            Holder currentMaterial = armorItem.getMaterial();
            Holder<ArmorMaterial> nextMaterial = this.getMaterialMap().get(currentMaterial);
            if (nextMaterial != null) {
                newItem = this.getTransformedItem(originalItem, this.getMaterialNames().get(nextMaterial));
            }
        }
        if (newItem.isEmpty()) {
            return stack;
        }
        Integer currentMaxDamage = (Integer)stack.get(ModDataComponents.ORIGINAL_MAX_DAMAGE.get());
        if (currentMaxDamage != null) {
            stack.set(DataComponents.MAX_DAMAGE, (Object)currentMaxDamage);
            stack.remove(ModDataComponents.ORIGINAL_MAX_DAMAGE.get());
            Integer currentDamage = (Integer)stack.get(DataComponents.DAMAGE);
            if (currentDamage == null || currentDamage <= 0) {
                return stack;
            }
            stack.set(DataComponents.DAMAGE, (Object)(currentDamage * 3));
        }
        ItemStack transformed = new ItemStack((ItemLike)newItem.get(), stack.getCount());
        DataComponentPatch originalPatch = stack.getComponentsPatch();
        transformed.applyComponents(originalPatch);
        boolean isNotCursedItem = true;
        CustomData customDataComponent = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (customDataComponent != null) {
            CompoundTag customDataTag = customDataComponent.getUnsafe();
            boolean bl = isNotCursedItem = !customDataTag.getBoolean("cursed_item");
        }
        if (isNotCursedItem) {
            int maxDamage = transformed.getMaxDamage();
            int scaledDamage = Math.min((int)((double)stack.getDamageValue() / (double)stack.getMaxDamage() * (double)maxDamage), maxDamage - 1);
            transformed.setDamageValue(scaledDamage);
        }
        ItemEnchantments enchantments = stack.getTagEnchantments();
        EnchantmentHelper.setEnchantments((ItemStack)transformed, (ItemEnchantments)enchantments);
        return transformed;
    }

    protected Optional<Item> getTransformedItem(Item original, String targetMaterialName) {
        ResourceLocation originalId = BuiltInRegistries.ITEM.getKey((Object)original);
        String originalName = originalId.getPath();
        int underscoreIndex = originalName.indexOf(95);
        if (underscoreIndex == -1) {
            return Optional.empty();
        }
        String armorType = originalName.substring(underscoreIndex);
        String nextItemName = targetMaterialName + armorType;
        ResourceLocation nextItemId = ResourceLocation.tryParse((String)(originalId.getNamespace() + ":" + nextItemName));
        if (nextItemId == null) {
            return Optional.empty();
        }
        Item transformedItem = (Item)BuiltInRegistries.ITEM.get(nextItemId);
        return Optional.of(transformedItem).filter(item -> item != Items.AIR);
    }

    @Override
    public double getDefaultDurationMultiplier() {
        return 0.0;
    }
}

