/*
 * Decompiled with CFR 0.152.
 */
package com.a3ot.eventhorizon.events.subclasses;

import com.a3ot.eventhorizon.events.AbstractEvent;
import com.a3ot.eventhorizon.events.utils.Utils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractInventoryEvent
implements AbstractEvent {
    @Override
    public void onStart(ServerLevel level) {
        level.players().stream().filter(Utils::isValidPlayer).forEach(player -> {
            this.processAllSlots(level, (Player)player);
            player.getInventory().setChanged();
        });
    }

    @Override
    public void onTick(ServerLevel level) {
        level.players().stream().filter(Utils::isValidPlayer).forEach(player -> {
            this.processAllSlots(level, (Player)player);
            player.getInventory().setChanged();
        });
    }

    @Override
    public void onEnd(ServerLevel level) {
        level.players().forEach(player -> {
            this.restoreAllSlots(level, (Player)player);
            player.getInventory().setChanged();
        });
    }

    protected boolean includeMainInventory() {
        return true;
    }

    protected boolean includeArmor() {
        return true;
    }

    protected boolean includeOffhand() {
        return true;
    }

    protected void processAllSlots(ServerLevel level, Player player) {
        for (int i = 0; i < 41; ++i) {
            IBasicEvent basicEvent;
            AbstractInventoryEvent newStack;
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.isEmpty()) continue;
            boolean process = false;
            if (i < 36 && this.includeMainInventory()) {
                process = true;
            } else if (i >= 36 && i < 40 && this.includeArmor()) {
                process = true;
            } else if (i == 40 && this.includeOffhand()) {
                process = true;
            }
            if (!process) continue;
            AbstractInventoryEvent abstractInventoryEvent = this;
            if (abstractInventoryEvent instanceof ILevelAwareEvent) {
                ILevelAwareEvent levelEvent = (ILevelAwareEvent)((Object)abstractInventoryEvent);
                newStack = levelEvent.modifyItem(stack, level);
                if (ItemStack.matches((ItemStack)stack, (ItemStack)newStack)) continue;
                player.getInventory().setItem(i, (ItemStack)newStack);
                continue;
            }
            newStack = this;
            if (!(newStack instanceof IBasicEvent) || ItemStack.matches((ItemStack)stack, (ItemStack)(newStack = (basicEvent = (IBasicEvent)((Object)newStack)).modifyItem(stack)))) continue;
            player.getInventory().setItem(i, (ItemStack)newStack);
        }
    }

    protected void restoreAllSlots(ServerLevel level, Player player) {
        for (int i = 0; i < 41; ++i) {
            IBasicEvent basicEvent;
            AbstractInventoryEvent newStack;
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.isEmpty()) continue;
            AbstractInventoryEvent abstractInventoryEvent = this;
            if (abstractInventoryEvent instanceof ILevelAwareEvent) {
                ILevelAwareEvent levelEvent = (ILevelAwareEvent)((Object)abstractInventoryEvent);
                newStack = levelEvent.restoreItem(stack, level);
                if (ItemStack.matches((ItemStack)stack, (ItemStack)newStack)) continue;
                player.getInventory().setItem(i, (ItemStack)newStack);
                continue;
            }
            newStack = this;
            if (!(newStack instanceof IBasicEvent) || ItemStack.matches((ItemStack)stack, (ItemStack)(newStack = (basicEvent = (IBasicEvent)((Object)newStack)).restoreItem(stack)))) continue;
            player.getInventory().setItem(i, (ItemStack)newStack);
        }
    }

    public static interface ILevelAwareEvent {
        public ItemStack modifyItem(ItemStack var1, ServerLevel var2);

        default public ItemStack restoreItem(ItemStack stack, ServerLevel level) {
            return stack;
        }
    }

    public static interface IBasicEvent {
        public ItemStack modifyItem(ItemStack var1);

        default public ItemStack restoreItem(ItemStack stack) {
            return stack;
        }
    }
}

