/*
 * Decompiled with CFR 0.152.
 */
package com.a3ot.eventhorizon.events.subclasses;

import com.a3ot.eventhorizon.events.AbstractEvent;
import com.a3ot.eventhorizon.events.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public abstract class AbstractPlayerAttributeEvent
implements AbstractEvent {
    protected final Map<Holder<Attribute>, AttributeModifier> modifiers = new HashMap<Holder<Attribute>, AttributeModifier>();

    protected void applyModifiers(LivingEntity entity) {
        this.modifiers.forEach((attribute, modifier) -> {
            AttributeInstance instance = entity.getAttribute(attribute);
            if (instance != null && !instance.hasModifier(modifier.id())) {
                instance.addTransientModifier(modifier);
            }
        });
    }

    protected void restoreOriginalValues(LivingEntity entity) {
        this.modifiers.forEach((attribute, modifier) -> {
            AttributeInstance instance = entity.getAttribute(attribute);
            if (instance != null) {
                instance.removeModifier(modifier.id());
            }
        });
    }

    protected abstract void defineModifiers();

    @Override
    public void onStart(ServerLevel level) {
        this.defineModifiers();
        level.players().stream().filter(Utils::isValidPlayer).forEach(this::applyModifiers);
    }

    @Override
    public void onEnd(ServerLevel level) {
        level.players().forEach(this::restoreOriginalValues);
    }
}

