/*
 * Decompiled with CFR 0.152.
 */
package com.a3ot.eventhorizon.events.subclasses;

import com.a3ot.eventhorizon.events.subclasses.AbstractInventoryEvent;
import com.a3ot.eventhorizon.events.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractRandomSlotInventoryEvent
extends AbstractInventoryEvent {
    protected abstract int getSlotsToProcessCount();

    protected boolean isSlotEligible(Player player, int slot, ItemStack stack) {
        return !stack.isEmpty();
    }

    @Override
    public void onStart(ServerLevel level) {
        level.players().stream().filter(Utils::isValidPlayer).forEach(player -> {
            this.processRandomSlots(level, (Player)player);
            player.getInventory().setChanged();
        });
    }

    @Override
    public void onTick(ServerLevel level) {
        level.players().stream().filter(Utils::isValidPlayer).forEach(player -> {
            this.processRandomSlots(level, (Player)player);
            player.getInventory().setChanged();
        });
    }

    protected void processRandomSlots(ServerLevel level, Player player) {
        ArrayList<Integer> eligibleSlots = new ArrayList<Integer>();
        for (int i = 0; i < 41; ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            boolean process = false;
            if (i < 36 && this.includeMainInventory()) {
                process = true;
            } else if (i >= 36 && i < 40 && this.includeArmor()) {
                process = true;
            } else if (i == 40 && this.includeOffhand()) {
                process = true;
            }
            if (!process || !this.isSlotEligible(player, i, stack)) continue;
            eligibleSlots.add(i);
        }
        Collections.shuffle(eligibleSlots);
        int slotsToProcess = Math.min(this.getSlotsToProcessCount(), eligibleSlots.size());
        for (int i = 0; i < slotsToProcess; ++i) {
            AbstractInventoryEvent.IBasicEvent basicEvent;
            AbstractRandomSlotInventoryEvent newStack;
            int slotIndex = (Integer)eligibleSlots.get(i);
            ItemStack stack = player.getInventory().getItem(slotIndex);
            AbstractRandomSlotInventoryEvent abstractRandomSlotInventoryEvent = this;
            if (abstractRandomSlotInventoryEvent instanceof AbstractInventoryEvent.ILevelAwareEvent) {
                AbstractInventoryEvent.ILevelAwareEvent levelEvent = (AbstractInventoryEvent.ILevelAwareEvent)((Object)abstractRandomSlotInventoryEvent);
                newStack = levelEvent.modifyItem(stack, level);
                if (ItemStack.matches((ItemStack)stack, (ItemStack)newStack)) continue;
                player.getInventory().setItem(slotIndex, (ItemStack)newStack);
                continue;
            }
            newStack = this;
            if (!(newStack instanceof AbstractInventoryEvent.IBasicEvent) || ItemStack.matches((ItemStack)stack, (ItemStack)(newStack = (basicEvent = (AbstractInventoryEvent.IBasicEvent)((Object)newStack)).modifyItem(stack)))) continue;
            player.getInventory().setItem(slotIndex, (ItemStack)newStack);
        }
    }
}

