/*
 * Decompiled with CFR 0.152.
 */
package com.a3ot.eventhorizon.events.utils;

import com.a3ot.eventhorizon.events.client.CuteFontEvent;
import com.a3ot.eventhorizon.events.utils.CuteFragment;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.FormattedCharSink;
import org.jetbrains.annotations.NotNull;

public class CuteOrderedText
implements FormattedCharSequence {
    private final FormattedCharSequence composite;

    public CuteOrderedText(FormattedCharSequence wrapped) {
        List<CuteFragment> fragments = this.extractFragments(wrapped);
        ArrayList<String> transformedFragments = new ArrayList<String>();
        ArrayList<Style> styles = new ArrayList<Style>();
        StringBuilder combinedText = new StringBuilder();
        for (CuteFragment fragment : fragments) {
            String transformed = CuteFontEvent.localTransform(fragment.getText());
            transformedFragments.add(transformed);
            combinedText.append(transformed);
            styles.add(fragment.getStyle());
        }
        String globalText = CuteFontEvent.globalTransform(combinedText.toString());
        ArrayList<FormattedCharSequence> globalFragments = new ArrayList<FormattedCharSequence>();
        int pos = 0;
        for (int i = 0; i < fragments.size() && pos < globalText.length(); ++i) {
            int length = ((String)transformedFragments.get(i)).length();
            int end = Math.min(pos + length, globalText.length());
            globalFragments.add(FormattedCharSequence.forward((String)globalText.substring(pos, end), (Style)((Style)styles.get(i))));
            pos = end;
        }
        if (pos < globalText.length()) {
            globalFragments.add(FormattedCharSequence.forward((String)globalText.substring(pos), (Style)(!styles.isEmpty() ? (Style)styles.getLast() : Style.EMPTY)));
        }
        this.composite = FormattedCharSequence.composite(globalFragments);
    }

    private List<CuteFragment> extractFragments(FormattedCharSequence sequence) {
        ArrayList<CuteFragment> fragments = new ArrayList<CuteFragment>();
        StringBuilder[] currentText = new StringBuilder[]{new StringBuilder()};
        Style[] currentStyle = new Style[]{null};
        sequence.accept((index, style, codePoint) -> {
            if (currentStyle[0] == null) {
                currentStyle[0] = style;
                currentText[0].appendCodePoint(codePoint);
                return true;
            }
            if (!style.equals((Object)currentStyle[0]) && !currentText[0].isEmpty()) {
                fragments.add(new CuteFragment(currentStyle[0], currentText[0].toString()));
                currentText[0] = new StringBuilder();
                currentStyle[0] = style;
            }
            currentText[0].appendCodePoint(codePoint);
            return true;
        });
        if (!currentText[0].isEmpty()) {
            fragments.add(new CuteFragment(currentStyle[0], currentText[0].toString()));
        }
        return fragments;
    }

    public boolean accept(@NotNull FormattedCharSink visitor) {
        return this.composite.accept(visitor);
    }
}

