/*
 * Decompiled with CFR 0.152.
 */
package com.a3ot.eventhorizon.events.utils;

import com.a3ot.eventhorizon.data.ModTags;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;

public class Utils {
    private static final Map<LivingEntity, Long> cooldowns = new HashMap<LivingEntity, Long>();
    private static final long COOLDOWN_DURATION = 100L;

    public static boolean isValidPlayer(Player player) {
        return player != null && player.isAlive() && !player.isCreative() && !player.isSpectator();
    }

    public static boolean isValidDeadPlayer(Player player) {
        return player != null && !player.isCreative() && !player.isSpectator();
    }

    public static void changeItemInHand(Player player, ItemStack newItem) {
        ItemStack oldItem = player.getItemInHand(InteractionHand.MAIN_HAND);
        player.setItemInHand(InteractionHand.MAIN_HAND, newItem);
        Utils.giveItem(player, oldItem);
    }

    public static void giveItem(Player player, ItemStack newItem) {
        int maxStackSize;
        int maxTotalItems;
        if (newItem.isEmpty()) {
            return;
        }
        int count = newItem.getCount();
        if (count > (maxTotalItems = (maxStackSize = newItem.getMaxStackSize()) * 100)) {
            int itemsForThisStack;
            for (int itemsToProcess = count; itemsToProcess > 0; itemsToProcess -= itemsForThisStack) {
                itemsForThisStack = Math.min(maxStackSize, itemsToProcess);
                ItemStack stackToGive = newItem.copyWithCount(itemsForThisStack);
                boolean addedToInventory = player.getInventory().add(stackToGive);
                if (!addedToInventory || !stackToGive.isEmpty()) continue;
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((player.getRandom().nextFloat() - player.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                player.containerMenu.broadcastChanges();
            }
        } else {
            ItemEntity entity;
            boolean addedToInventory = player.getInventory().add(newItem);
            if (addedToInventory && newItem.isEmpty()) {
                player.playNotifySound(SoundEvents.ITEM_PICKUP, SoundSource.MASTER, 1.0f, 1.0f);
            } else if (!newItem.isEmpty() && (entity = player.drop(newItem, false)) != null) {
                entity.setNoPickUpDelay();
                entity.setTarget(player.getUUID());
            }
        }
    }

    public static void airFilling(ServerLevel level, int x1, int y1, int z1, int x2, int y2, int z2) {
        Utils.airFilling(level, new BlockPos(x1, y1, z1), new BlockPos(x2, y2, z2));
    }

    public static void airFilling(ServerLevel level, BlockPos pos1, BlockPos pos2) {
        BlockPos.betweenClosedStream((BlockPos)pos1, (BlockPos)pos2).forEach(pos -> {
            BlockState state = level.getBlockState(pos);
            if (state.is(ModTags.Blocks.IMPORTANT_BLOCKS) || state.isEmpty()) {
                return;
            }
            if (state.is(Tags.Blocks.STORAGE_BLOCKS)) {
                level.destroyBlock(pos, true);
            } else {
                level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            }
        });
    }

    public static void blockFilling(ServerLevel level, int x1, int y1, int z1, int x2, int y2, int z2, Block block) {
        Utils.blockFilling(level, new BlockPos(x1, y1, z1), new BlockPos(x2, y2, z2), block);
    }

    public static void blockFilling(ServerLevel level, BlockPos pos1, BlockPos pos2, Block block) {
        BlockPos.betweenClosedStream((BlockPos)pos1, (BlockPos)pos2).forEach(pos -> {
            BlockState state = level.getBlockState(pos);
            if (state.is(ModTags.Blocks.IMPORTANT_BLOCKS)) {
                return;
            }
            if (state.is(Tags.Blocks.STORAGE_BLOCKS)) {
                level.destroyBlock(pos, true);
            } else {
                level.setBlock(pos, block.defaultBlockState(), 3);
            }
        });
    }

    public static void blockFilling(ServerLevel level, BlockPos pos1, BlockPos pos2, BlockState blockState) {
        BlockPos.betweenClosedStream((BlockPos)pos1, (BlockPos)pos2).forEach(pos -> {
            BlockState currentState = level.getBlockState(pos);
            if (currentState.is(ModTags.Blocks.IMPORTANT_BLOCKS)) {
                return;
            }
            if (currentState.is(Tags.Blocks.STORAGE_BLOCKS)) {
                level.destroyBlock(pos, true);
            } else {
                level.setBlock(pos, blockState, 3);
            }
        });
    }

    public static boolean isBlockPosHasTag(Level level, BlockPos pos, TagKey<Block> tag) {
        BlockState state = level.getBlockState(pos);
        return state.is(tag);
    }

    public static int lightManager(BlockPos pos, Level level) {
        return Utils.lightManager(pos, level, 0, 0);
    }

    public static int lightManager(BlockPos pos, Level level, int skyLightModifier, int blockLightModifier) {
        int skyLight;
        if (level.dimension() == Level.END) {
            skyLight = 0;
        } else if (level.dimension() == Level.NETHER) {
            skyLight = 4;
        } else {
            skyLight = level.getBrightness(LightLayer.SKY, pos);
            if (!level.isDay()) {
                skyLight -= 11;
            }
        }
        int blockLight = level.getBrightness(LightLayer.BLOCK, pos);
        return Math.max(skyLight + skyLightModifier, blockLight + blockLightModifier);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playItemActivation(ItemStack itemStack, int entityId) {
        Player player;
        Entity entity;
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        if (level != null && (entity = level.getEntity(entityId)) instanceof Player && (player = (Player)entity) == mc.player) {
            mc.gameRenderer.displayItemActivation(itemStack);
        }
    }

    public static void ChorusTeleport(LivingEntity entity, Level level) {
        Utils.ChorusTeleport(entity, level, 16, 48);
    }

    public static void ChorusTeleport(LivingEntity entity, Level level, int minDistance, int maxDistance) {
        if (minDistance > maxDistance) {
            int temp = minDistance;
            minDistance = maxDistance;
            maxDistance = temp;
        }
        long currentTime = entity.level().getGameTime();
        if (cooldowns.containsKey(entity) && cooldowns.get(entity) > currentTime) {
            return;
        }
        Vec3 originalPos = entity.position();
        int maxAttempts = 32;
        for (int i = 0; i < maxAttempts; ++i) {
            double angle = entity.getRandom().nextDouble() * 2.0 * Math.PI;
            double distance = (double)minDistance + entity.getRandom().nextDouble() * (double)(maxDistance - minDistance);
            double dx = Math.cos(angle) * distance;
            double dz = Math.sin(angle) * distance;
            double newX = originalPos.x() + dx;
            double newZ = originalPos.z() + dz;
            double minY = level.getMinBuildHeight();
            double maxY = minY + (double)level.getHeight() - 1.0;
            double newY = Mth.clamp((double)(originalPos.y() + (entity.getRandom().nextDouble() - 0.5) * (double)(maxDistance - minDistance) * 0.5), (double)minY, (double)maxY);
            if (entity.isPassenger()) {
                entity.stopRiding();
            }
            Vec3 vec3 = entity.position();
            EntityTeleportEvent.ChorusFruit event = EventHooks.onChorusFruitTeleport((LivingEntity)entity, (double)newX, (double)newY, (double)newZ);
            if (event.isCanceled() || !entity.randomTeleport(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true)) continue;
            cooldowns.put(entity, currentTime + 100L);
            level.gameEvent((Holder)GameEvent.TELEPORT, vec3, GameEvent.Context.of((Entity)entity));
            entity.resetFallDistance();
            SoundSource soundsource = SoundSource.PLAYERS;
            level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.CHORUS_FRUIT_TELEPORT, soundsource);
            if (!(entity instanceof Player)) break;
            Player player = (Player)entity;
            player.resetCurrentImpulseContext();
            break;
        }
    }

    public static boolean isOnCooldown(LivingEntity entity) {
        long currentTime = entity.level().getGameTime();
        return cooldowns.containsKey(entity) && cooldowns.get(entity) > currentTime;
    }

    public static void setCooldown(LivingEntity entity) {
        cooldowns.put(entity, entity.level().getGameTime() + 100L);
    }

    public static void clearTeleportCooldowns() {
        cooldowns.clear();
    }
}

