/*
 * Decompiled with CFR 0.152.
 */
package com.a3ot.eventhorizon.gui;

import com.a3ot.eventhorizon.ServerTick;
import com.a3ot.eventhorizon.events.AbstractEvent;
import com.a3ot.eventhorizon.events.server.UnknownEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;

public class ActiveEventScoreBoard {
    private static final String OBJECTIVE_NAME = "ActiveEvents";
    private static Objective objective;

    public static void initialize(MinecraftServer server) {
        ServerScoreboard scoreboard = server.getScoreboard();
        objective = scoreboard.getObjective(OBJECTIVE_NAME);
        if (objective == null) {
            objective = scoreboard.addObjective(OBJECTIVE_NAME, ObjectiveCriteria.DUMMY, (Component)Component.translatable((String)"eventhorizon.timer.sidebar.message"), ObjectiveCriteria.RenderType.INTEGER, true, null);
            scoreboard.setDisplayObjective(DisplaySlot.SIDEBAR, objective);
        }
    }

    public static void update(MinecraftServer server) {
        if (objective == null) {
            return;
        }
        ServerScoreboard scoreboard = server.getScoreboard();
        Map<AbstractEvent, Integer> activeEvents = ServerTick.getActiveEvents();
        if (activeEvents.isEmpty() || UnknownEvent.isActive()) {
            if (scoreboard.getDisplayObjective(DisplaySlot.SIDEBAR) == objective) {
                scoreboard.setDisplayObjective(DisplaySlot.SIDEBAR, null);
            }
            return;
        }
        if (scoreboard.getDisplayObjective(DisplaySlot.SIDEBAR) != objective) {
            scoreboard.setDisplayObjective(DisplaySlot.SIDEBAR, objective);
        }
        HashSet<String> currentEventNames = new HashSet<String>();
        for (Map.Entry<AbstractEvent, Integer> entry : activeEvents.entrySet()) {
            AbstractEvent abstractEvent = entry.getKey();
            String eventName = abstractEvent.getConfigName();
            currentEventNames.add(eventName);
        }
        Collection allHolders = scoreboard.getTrackedPlayers();
        for (ScoreHolder scoreHolder : allHolders) {
            String holderName = scoreHolder.getScoreboardName();
            if (currentEventNames.contains(holderName)) continue;
            scoreboard.resetSinglePlayerScore(scoreHolder, objective);
        }
        for (Map.Entry entry : activeEvents.entrySet()) {
            AbstractEvent event = (AbstractEvent)entry.getKey();
            int remainingSeconds = (Integer)entry.getValue() / 20 + 1;
            String eventName = event.getConfigName();
            ScoreHolder holder = ScoreHolder.forNameOnly((String)eventName);
            ScoreAccess score = scoreboard.getOrCreatePlayerScore(holder, objective);
            score.set(remainingSeconds);
            score.display((Component)Component.translatable((String)event.getName()));
        }
    }

    public static void deinitialize(MinecraftServer server) {
        if (objective != null) {
            server.getScoreboard().removeObjective(objective);
            objective = null;
        }
    }
}

