/*
 * Decompiled with CFR 0.152.
 */
package com.a3ot.eventhorizon.gui;

import com.a3ot.eventhorizon.ServerTick;
import com.a3ot.eventhorizon.events.server.UnknownEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;

public class TimerBossBar {
    private static ServerBossEvent bossBar;
    private static final List<UUID> trackedPlayers;

    public static void update(int tickCounter, int totalTicks) {
        if (bossBar != null) {
            bossBar.setVisible(!UnknownEvent.isActive());
            int secondsLeft = (totalTicks - tickCounter) / 20 + 1;
            bossBar.setName((Component)Component.translatable((String)"eventhorizon.timer.bossbar.message", (Object[])new Object[]{secondsLeft}));
            bossBar.setProgress((float)tickCounter / (float)totalTicks);
        }
    }

    public static void setBossBarColor(boolean bool) {
        if (bossBar != null) {
            BossEvent.BossBarColor color = bool ? BossEvent.BossBarColor.GREEN : BossEvent.BossBarColor.BLUE;
            bossBar.setColor(color);
        }
    }

    public static void initialize(MinecraftServer server) {
        if (bossBar == null && server != null) {
            int totalTicks = ServerTick.updateTotalTicks();
            bossBar = new ServerBossEvent((Component)Component.translatable((String)"eventhorizon.timer.bossbar.message", (Object[])new Object[]{totalTicks / 20}), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.PROGRESS);
            bossBar.setProgress(0.0f);
            server.getPlayerList().getPlayers().forEach(player -> {
                bossBar.addPlayer(player);
                trackedPlayers.add(player.getUUID());
            });
        }
    }

    public static void deinitialize(MinecraftServer server) {
        if (bossBar != null && server != null) {
            trackedPlayers.forEach(uuid -> {
                ServerPlayer player = server.getPlayerList().getPlayer(uuid);
                if (player != null) {
                    bossBar.removePlayer(player);
                }
            });
            trackedPlayers.clear();
            bossBar = null;
        }
    }

    public static void addPlayerToBossBar(ServerPlayer player) {
        if (bossBar != null) {
            bossBar.addPlayer(player);
            trackedPlayers.add(player.getUUID());
        }
    }

    public static void removePlayerFromBossBar(UUID uuid) {
        trackedPlayers.remove(uuid);
    }

    static {
        trackedPlayers = new ArrayList<UUID>();
    }
}

