/*
 * Decompiled with CFR 0.152.
 */
package com.a3ot.eventhorizon.handlers;

import com.a3ot.eventhorizon.EventHorizon;
import com.a3ot.eventhorizon.ServerTick;
import com.a3ot.eventhorizon.api.event.PlayerChangeGameModeEvent;
import com.a3ot.eventhorizon.events.AbstractEvent;
import com.a3ot.eventhorizon.events.EventSide;
import com.a3ot.eventhorizon.gui.TimerBossBar;
import com.a3ot.eventhorizon.network.packet.ClientEventPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;

@EventBusSubscriber(modid="eventhorizon")
public class ServerHandler {
    private static final Map<UUID, Boolean> CLIENT_EVENT_SOUND_MAP = new HashMap<UUID, Boolean>();
    private static final Map<UUID, Boolean> CLIENT_WARNING_SOUND_MAP = new HashMap<UUID, Boolean>();

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        ServerTick.pause(event.getServer());
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (!ServerTick.isEnabled()) {
            return;
        }
        ServerHandler.sendMessage(player2);
        TimerBossBar.addPlayerToBossBar(player2);
        if (!ServerTick.isRun()) {
            return;
        }
        ServerHandler.syncActiveEventsWithPlayer(player2);
    }

    public static void syncActiveEventsWithPlayer(ServerPlayer player) {
        for (Map.Entry<AbstractEvent, Integer> entry : ServerTick.getActiveEvents().entrySet()) {
            AbstractEvent event = entry.getKey();
            if (event.getSide() != EventSide.CLIENT) {
                event.playerRespawnOrJoin((Player)player, player.level());
            }
            if (event.getSide() == EventSide.SERVER) continue;
            ClientEventPacket.sendClientEventPacket(event, ClientEventPacket.EventType.START, player.server);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeGameMode(PlayerChangeGameModeEvent.Post event) {
        if (!ServerTick.isRun()) {
            return;
        }
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        player2.setGameMode(event.getNewGameMode());
        ServerHandler.syncActiveEventsWithPlayer(player2);
    }

    public static void sendMessage(ServerPlayer player) {
        if (!ServerTick.isRun()) {
            MutableComponent command = Component.translatable((String)"eventhorizon.message.start_command").withStyle(ChatFormatting.GREEN).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/event start"))).withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"/event start"))));
            MutableComponent message = Component.translatable((String)"eventhorizon.message.ready", (Object[])new Object[]{command});
            player.sendSystemMessage((Component)message);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        Level level = player.level();
        for (AbstractEvent abstractEvent : ServerTick.getActiveEvents().keySet()) {
            EventHorizon.LOGGER.info(abstractEvent.getConfigName());
            if (abstractEvent.getSide() == EventSide.CLIENT) continue;
            abstractEvent.playerRespawnOrJoin(player, level);
        }
    }

    @SubscribeEvent
    public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerPlayer serverPlayer = (ServerPlayer)event.getEntity();
        TimerBossBar.removePlayerFromBossBar(serverPlayer.getUUID());
        UUID uuid = serverPlayer.getUUID();
        CLIENT_EVENT_SOUND_MAP.remove(uuid);
        CLIENT_WARNING_SOUND_MAP.remove(uuid);
    }

    public static void setClientEventSound(ServerPlayer player, boolean eventSound) {
        CLIENT_EVENT_SOUND_MAP.put(player.getUUID(), eventSound);
    }

    public static boolean isClientEventSound(ServerPlayer player) {
        return CLIENT_EVENT_SOUND_MAP.getOrDefault(player.getUUID(), true);
    }

    public static void setClientWarningSound(ServerPlayer player, boolean warningSound) {
        CLIENT_WARNING_SOUND_MAP.put(player.getUUID(), warningSound);
    }

    public static boolean isClientWarningSound(ServerPlayer player) {
        return CLIENT_WARNING_SOUND_MAP.getOrDefault(player.getUUID(), true);
    }
}

