/*
 * Decompiled with CFR 0.152.
 */
package com.a3ot.eventhorizon.handlers;

import com.a3ot.eventhorizon.ServerTick;
import com.a3ot.eventhorizon.data.DeathStorage;
import com.a3ot.eventhorizon.data.WorldData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.LevelEvent;

@EventBusSubscriber
public class WorldDataHandler {
    private static WorldData overworldData = null;

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        ServerLevel serverLevel;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (serverLevel = (ServerLevel)levelAccessor).dimension() == Level.OVERWORLD) {
            overworldData = WorldDataHandler.get((Level)serverLevel);
            ServerTick.setTickCounter(overworldData.getTickCounter());
            ServerTick.getActiveEvents().clear();
            ServerTick.getActiveEvents().putAll(overworldData.getActiveEvents());
            DeathStorage.setWorldDataDeathMap(overworldData.getDeathDataMap());
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(LevelEvent.Unload event) {
        if (overworldData != null) {
            overworldData.setTickCounter(ServerTick.getTickCounter());
            overworldData.getActiveEvents().clear();
            overworldData.getActiveEvents().putAll(ServerTick.getActiveEvents());
            overworldData.getDeathDataMap().clear();
            overworldData.getDeathDataMap().putAll(DeathStorage.getWorldDataDeathMap());
        }
    }

    public static WorldData get(Level level) {
        ServerLevel serverLevel;
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).dimension() == Level.OVERWORLD) {
            return (WorldData)serverLevel.getDataStorage().computeIfAbsent(WorldData.FACTORY, "eventhorizon_world_data");
        }
        throw new IllegalStateException("WorldData can only be accessed on the server side for Overworld");
    }
}

