/*
 * Decompiled with CFR 0.152.
 */
package com.a3ot.eventhorizon.mixin;

import com.a3ot.eventhorizon.data.PlayerBrushData;
import com.a3ot.eventhorizon.events.server.ArcheologyPlusEvent;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BrushItem.class})
public abstract class BrushItemMixin {
    @Unique
    private static final Map<Player, PlayerBrushData> BRUSH_DATA = new WeakHashMap<Player, PlayerBrushData>();
    @Unique
    private static List<LootTable> eventhorizon$validLootTables = List.of();

    @Inject(method={"onUseTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/BrushItem;calculateHitResult(Lnet/minecraft/world/entity/player/Player;)Lnet/minecraft/world/phys/HitResult;")})
    private void onBrushUse(Level level, LivingEntity entity, ItemStack stack, int remainingUseDuration, CallbackInfo ci) {
        long elapsed;
        Player player;
        block10: {
            block9: {
                if (!(entity instanceof Player)) break block9;
                player = (Player)entity;
                if (!level.isClientSide() && remainingUseDuration >= 0 && ArcheologyPlusEvent.active) break block10;
            }
            return;
        }
        PlayerBrushData data = BRUSH_DATA.computeIfAbsent(player, k -> new PlayerBrushData());
        HitResult hitResult = ((BrushItem)this).calculateHitResult(player);
        if (hitResult.getType() == HitResult.Type.BLOCK) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            BlockPos newPos = blockHitResult.getBlockPos();
            BlockState state = level.getBlockState(newPos);
            if (state.is(Blocks.SAND) || state.is(Blocks.GRAVEL) || state.is(Blocks.SOUL_SAND)) {
                if (data.targetPos == null || !data.targetPos.equals((Object)newPos)) {
                    data.targetPos = newPos;
                    data.lastBrushStartTime = level.getGameTime();
                }
            } else {
                BRUSH_DATA.remove(player);
            }
        }
        if (data.targetPos != null && data.lastBrushStartTime != -1L && (elapsed = level.getGameTime() - data.lastBrushStartTime) >= 10L) {
            this.eventhorizon$spawnLootAndDestroyBlock(level, data.targetPos, player, stack);
            BRUSH_DATA.remove(player);
        }
    }

    @Unique
    private void eventhorizon$spawnLootAndDestroyBlock(Level level, BlockPos pos, Player player, ItemStack stack) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (eventhorizon$validLootTables.isEmpty()) {
            BrushItemMixin.eventhorizon$refreshLootTables(serverLevel);
            if (eventhorizon$validLootTables.isEmpty()) {
                return;
            }
        }
        LootTable lootTable = eventhorizon$validLootTables.get(level.random.nextInt(eventhorizon$validLootTables.size()));
        BlockState blockState = level.getBlockState(pos);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        LootParams lootParams = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.BLOCK_STATE, (Object)blockState).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)blockEntity).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY).create(LootContextParamSets.BLOCK);
        ObjectArrayList loot = lootTable.getRandomItems(lootParams);
        if (!loot.isEmpty()) {
            level.destroyBlock(pos, false);
            ItemStack randomItem = (ItemStack)loot.get(level.random.nextInt(loot.size()));
            if (!randomItem.isEmpty()) {
                ItemEntity itemEntity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, randomItem);
                level.addFreshEntity((Entity)itemEntity);
            }
        }
        EquipmentSlot equipmentslot = this.eventhorizon$getEquipmentSlot(player, stack);
        stack.hurtAndBreak(1, (LivingEntity)player, equipmentslot);
    }

    @Unique
    private static void eventhorizon$refreshLootTables(ServerLevel level) {
        eventhorizon$validLootTables = level.getServer().reloadableRegistries().get().registryOrThrow(Registries.LOOT_TABLE).stream().filter(table -> table != LootTable.EMPTY && (!table.getLootTableId().getNamespace().equals("minecraft") || table.getLootTableId().getPath().startsWith("chests/"))).collect(Collectors.toList());
    }

    @Unique
    private EquipmentSlot eventhorizon$getEquipmentSlot(Player player, ItemStack stack) {
        return stack.equals(player.getItemBySlot(EquipmentSlot.OFFHAND)) ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
    }
}

