/*
 * Decompiled with CFR 0.152.
 */
package com.a3ot.eventhorizon.mixin;

import com.a3ot.eventhorizon.api.event.FluidCollisionEvent;
import com.a3ot.eventhorizon.events.server.WideMobsEvent;
import com.a3ot.eventhorizon.handlers.client.ClientVariables;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public class EntityMixin {
    @Shadow
    protected boolean wasTouchingWater;
    @Shadow
    private FluidType forgeFluidTypeOnEyes;
    @Shadow
    protected boolean wasEyeInWater;

    @ModifyVariable(method={"move"}, ordinal=1, index=3, name={"vec32"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/entity/Entity;collide(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;"))
    public Vec3 fluidCollision(Vec3 original) {
        Entity entity = (Entity)this;
        if (!(entity instanceof LivingEntity)) {
            return original;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        Level level = entity2.level();
        BlockPos sourcePos = entity2.blockPosition();
        if (original.y > 0.0) {
            return original;
        }
        BlockPos entityPos = entity2.blockPosition();
        BlockPos feetPos = entityPos.below();
        if (level.getFluidState(entityPos).isEmpty() && level.getFluidState(feetPos).isEmpty()) {
            return original;
        }
        int[][] offsets = new int[][]{{1, 0, 1}, {1, 0, 0}, {1, -1, 0}, {1, 0, -1}, {0, 0, 1}, {0, 0, 0}, {0, -1, 0}, {0, 0, -1}, {-1, 0, 1}, {-1, 0, 0}, {-1, -1, 0}, {-1, 0, -1}};
        double highestValue = original.y;
        FluidState highestFluid = null;
        for (int[] offset : offsets) {
            double height;
            VoxelShape shape;
            BlockPos pos = sourcePos.offset(offset[0], offset[1], offset[2]);
            FluidState fluidState = level.getFluidState(pos);
            if (fluidState.isEmpty() || !Shapes.joinIsNotEmpty((VoxelShape)(shape = Shapes.block().move((double)pos.getX(), (double)((float)pos.getY() + fluidState.getOwnHeight()), (double)pos.getZ())), (VoxelShape)Shapes.create((AABB)entity2.getBoundingBox().inflate(0.5)), (BooleanOp)BooleanOp.AND) || !(highestValue < (height = shape.max(Direction.Axis.Y) - entity2.getY() - 1.0))) continue;
            highestValue = height;
            highestFluid = fluidState;
        }
        if (highestFluid == null) {
            return original;
        }
        FluidCollisionEvent event = new FluidCollisionEvent(entity2, highestFluid);
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled() && !entity2.isShiftKeyDown()) {
            entity2.fallDistance = 0.0f;
            entity2.setOnGround(true);
            return new Vec3(original.x, highestValue, original.z);
        }
        return original;
    }

    @Inject(method={"getBoundingBox"}, at={@At(value="RETURN")}, cancellable=true)
    public void modifyHitbox(CallbackInfoReturnable<AABB> cir) {
        Entity entity = (Entity)this;
        WideMobsEvent.modifyHitbox(cir, entity);
    }

    @Shadow
    protected void setSharedFlag(int flag, boolean set) {
    }

    @Inject(method={"setSwimming"}, at={@At(value="HEAD")}, cancellable=true)
    private void forceSwimming(CallbackInfo ci) {
        Entity entity = (Entity)this;
        if (entity instanceof Player) {
            if (!ClientVariables.flyingFish) {
                return;
            }
            this.setSharedFlag(4, true);
            ci.cancel();
        }
    }

    @Inject(method={"updateFluidOnEyes"}, at={@At(value="TAIL")})
    private void invertWasEyeInWater(CallbackInfo ci) {
        Entity entity = (Entity)this;
        if (entity instanceof Player) {
            if (!ClientVariables.flyingFish) {
                return;
            }
            boolean actuallyInWater = entity.isEyeInFluid(FluidTags.WATER);
            this.wasEyeInWater = !actuallyInWater;
            this.forgeFluidTypeOnEyes = actuallyInWater ? (FluidType)NeoForgeMod.EMPTY_TYPE.value() : (FluidType)NeoForgeMod.WATER_TYPE.value();
        }
    }

    @Inject(method={"updateInWaterStateAndDoWaterCurrentPushing"}, at={@At(value="TAIL")})
    private void modifyUpdateInWaterState(CallbackInfo ci) {
        Entity entity = (Entity)this;
        if (entity instanceof Player) {
            if (!ClientVariables.flyingFish) {
                return;
            }
            this.wasTouchingWater = true;
        }
    }
}

