/*
 * Decompiled with CFR 0.152.
 */
package com.a3ot.eventhorizon.network;

import com.a3ot.eventhorizon.events.AbstractEvent;
import com.a3ot.eventhorizon.events.EventsRegistry;
import com.a3ot.eventhorizon.events.server.InventoryShuffleEvent;
import com.a3ot.eventhorizon.events.utils.Utils;
import com.a3ot.eventhorizon.handlers.ServerHandler;
import com.a3ot.eventhorizon.handlers.client.ClientVariables;
import com.a3ot.eventhorizon.network.packet.ClientEventPacket;
import com.a3ot.eventhorizon.network.packet.ClientVariableSyncPacket;
import com.a3ot.eventhorizon.network.packet.ItemActivationPacket;
import com.a3ot.eventhorizon.network.packet.ShuffleRequestPacket;
import com.a3ot.eventhorizon.network.packet.SoundConfigPacket;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@EventBusSubscriber(modid="eventhorizon")
public class NetworkHandler {
    @SubscribeEvent
    public static void onNetworkInit(RegisterPayloadHandlersEvent event) {
        final PayloadRegistrar registrar = event.registrar("eventhorizon").optional();
        NetworkHandler.registerPackets(new NetworkRegisterStrategy(){

            @Override
            public <T extends CustomPacketPayload> void register(PacketInfo<T> packetInfo) {
                registrar.playBidirectional(packetInfo.type(), packetInfo.streamCodec(), (packet, context) -> context.enqueueWork(() -> packetInfo.handler().handle(packet, context.player())));
            }
        });
    }

    public static void sendToClient(ServerPlayer serverPlayer, CustomPacketPayload packet) {
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToServer(CustomPacketPayload packet) {
        PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void registerPackets(NetworkRegisterStrategy strategy) {
        strategy.register(new PacketInfo<SoundConfigPacket>(SoundConfigPacket.TYPE, SoundConfigPacket.CODEC, (packet, player) -> {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ServerHandler.setClientEventSound(serverPlayer, packet.enableSound());
                ServerHandler.setClientWarningSound(serverPlayer, packet.enableWarning());
            }
        }));
        strategy.register(new PacketInfo<ClientEventPacket>(ClientEventPacket.TYPE, ClientEventPacket.CODEC, (packet, player) -> {
            AbstractEvent event;
            if (player.level().isClientSide() && (event = EventsRegistry.getEvent(packet.eventName())) != null) {
                switch (packet.eventType()) {
                    case START: {
                        event.onClientStart(player.level());
                        break;
                    }
                    case TICK: {
                        event.onClientTick(player.level());
                        break;
                    }
                    case END: {
                        event.onClientEnd(player.level());
                    }
                }
            }
        }));
        strategy.register(new PacketInfo<ItemActivationPacket>(ItemActivationPacket.TYPE, ItemActivationPacket.CODEC, (packet, player) -> {
            if (player.level().isClientSide()) {
                Utils.playItemActivation(packet.itemStack(), packet.entityId());
            }
        }));
        strategy.register(new PacketInfo<ShuffleRequestPacket>(ShuffleRequestPacket.TYPE, ShuffleRequestPacket.CODEC, (packet, player) -> {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                InventoryShuffleEvent.shuffle((Player)serverPlayer);
            }
        }));
        strategy.register(new PacketInfo<ClientVariableSyncPacket>(ClientVariableSyncPacket.TYPE, ClientVariableSyncPacket.CODEC, (packet, player) -> {
            if (player.level().isClientSide()) {
                ClientVariables.setVariable(packet.variableName(), packet.value());
            }
        }));
    }

    public static interface NetworkRegisterStrategy {
        public <T extends CustomPacketPayload> void register(PacketInfo<T> var1);
    }

    public record PacketInfo<T extends CustomPacketPayload>(CustomPacketPayload.Type<T> type, StreamCodec<RegistryFriendlyByteBuf, T> streamCodec, Handler<T> handler) {
    }

    public static interface Handler<T extends CustomPacketPayload> {
        public void handle(T var1, Player var2);
    }
}

