/*
 * Decompiled with CFR 0.152.
 */
package com.a3ot.eventhorizon.registry;

import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VaultBlock;
import net.minecraft.world.level.block.entity.trialspawner.PlayerDetector;
import net.minecraft.world.level.block.entity.vault.VaultConfig;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.NotNull;

public class CursedVault {
    public static final ResourceKey<LootTable> CURSED_VAULT_LOOT_TABLE_KEY = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"eventhorizon", (String)"chests/cursed_vault"));

    public static ItemStack createForCreativeTab(CreativeModeTab.ItemDisplayParameters parameters) {
        ItemStack stack = CursedVault.createCursedVaultItemStackBase();
        parameters.holders().lookupOrThrow(Registries.ENCHANTMENT).get(Enchantments.VANISHING_CURSE).ifPresent(vanishingCurseHolder -> CursedVault.addVanishingCurse(stack, (Holder<Enchantment>)vanishingCurseHolder));
        return stack;
    }

    public static ItemStack createForGameplay(ServerLevel level) {
        ItemStack stack = CursedVault.createCursedVaultItemStackBase();
        CursedVault.addVanishingCurse(stack, level);
        return stack;
    }

    private static ItemStack createCursedVaultItemStackBase() {
        ItemStack vaultItemStack = new ItemStack((ItemLike)Blocks.VAULT);
        BlockItemStateProperties blockStateProperties = (BlockItemStateProperties)vaultItemStack.getOrDefault(DataComponents.BLOCK_STATE, (Object)BlockItemStateProperties.EMPTY);
        vaultItemStack.set(DataComponents.BLOCK_STATE, (Object)blockStateProperties.with((Property)VaultBlock.OMINOUS, (Comparable)Boolean.valueOf(true)));
        VaultConfig config = CursedVault.getVaultConfig();
        VaultConfig.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)config).result().ifPresent(tag -> {
            if (tag instanceof CompoundTag) {
                CompoundTag configTag = (CompoundTag)tag;
                CompoundTag blockEntityData = new CompoundTag();
                blockEntityData.put("config", (Tag)configTag);
                blockEntityData.putString("id", "eventhorizon:cursed_vault");
                CustomData.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)blockEntityData).result().ifPresent(customData -> vaultItemStack.set(DataComponents.BLOCK_ENTITY_DATA, customData));
            }
        });
        vaultItemStack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"block.eventhorizon.cursed_vault").withStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).withColor(ChatFormatting.YELLOW)));
        vaultItemStack.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.translatable((String)"block.eventhorizon.cursed_vault.lore", (Object[])new Object[]{Component.translatable((String)"block.minecraft.diamond_block").withStyle(ChatFormatting.AQUA)}).withStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).withColor(ChatFormatting.GRAY)))));
        return vaultItemStack;
    }

    private static void addVanishingCurse(ItemStack stack, Holder<Enchantment> vanishingCurseHolder) {
        ItemEnchantments existingEnchantments = (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        ItemEnchantments.Mutable mutableEnchantments = new ItemEnchantments.Mutable(existingEnchantments);
        mutableEnchantments.upgrade(vanishingCurseHolder, 1);
        ItemEnchantments newEnchantments = mutableEnchantments.toImmutable();
        stack.set(DataComponents.ENCHANTMENTS, (Object)newEnchantments);
    }

    private static void addVanishingCurse(ItemStack stack, ServerLevel level) {
        Registry registry = level.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        Holder.Reference vanishingCurseHolder = registry.getHolderOrThrow(Enchantments.VANISHING_CURSE);
        CursedVault.addVanishingCurse(stack, (Holder<Enchantment>)vanishingCurseHolder);
    }

    @NotNull
    private static VaultConfig getVaultConfig() {
        double activationRange = 4.0;
        double deactivationRange = 4.5;
        ItemStack keyItem = new ItemStack((ItemLike)Items.DIAMOND_BLOCK.asItem(), 1);
        Optional overrideDisplayLootTable = Optional.empty();
        PlayerDetector playerDetector = PlayerDetector.NO_CREATIVE_PLAYERS;
        PlayerDetector.EntitySelector entitySelector = PlayerDetector.EntitySelector.SELECT_FROM_LEVEL;
        return new VaultConfig(CURSED_VAULT_LOOT_TABLE_KEY, activationRange, deactivationRange, keyItem, overrideDisplayLootTable, playerDetector, entitySelector);
    }
}

