/*
 * Decompiled with CFR 0.152.
 */
package com.a3ot.eventhorizon.registry;

import com.a3ot.eventhorizon.ServerTick;
import com.a3ot.eventhorizon.events.AbstractEvent;
import com.a3ot.eventhorizon.events.EventType;
import com.a3ot.eventhorizon.network.packet.ClientEventPacket;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.HoneyBottleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class EnchantedHoneyBottleItem
extends HoneyBottleItem {
    public EnchantedHoneyBottleItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entityLiving) {
        ItemStack result = super.finishUsingItem(stack, level, entityLiving);
        if (entityLiving instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entityLiving;
            ServerLevel serverLevel = (ServerLevel)level;
            Map<AbstractEvent, Integer> activeEvents = ServerTick.getActiveEvents();
            List<AbstractEvent> negativeEvents = activeEvents.keySet().stream().filter(event -> event.getType() == EventType.NEGATIVE).toList();
            if (!negativeEvents.isEmpty()) {
                AbstractEvent eventToRemove = negativeEvents.get(level.random.nextInt(negativeEvents.size()));
                activeEvents.remove(eventToRemove);
                eventToRemove.onEnd(serverLevel);
                ClientEventPacket.sendClientEventPacket(eventToRemove, ClientEventPacket.EventType.END, serverPlayer.getServer());
                EnchantedHoneyBottleItem.sendEventMessage(serverLevel, eventToRemove);
            }
        }
        return result;
    }

    private static void sendEventMessage(ServerLevel level, AbstractEvent event) {
        level.getServer().getPlayerList().getPlayers().forEach(player -> {
            player.sendSystemMessage((Component)Component.literal((String)"[Event Horizon] ").append((Component)Component.translatable((String)"item.eventhorizon.enchanted_honey_bottle.clear", (Object[])new Object[]{Component.translatable((String)event.getName()).withStyle(event.getColor())})).withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)event.getDescription())))));
            player.playNotifySound(SoundEvents.AMETHYST_BLOCK_BREAK, SoundSource.MASTER, 1.0f, 1.0f);
        });
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"item.eventhorizon.enchanted_honey_bottle.description").withStyle(ChatFormatting.GRAY));
    }
}

