/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.skydrop;

import com.j2k.skydrop.command.ModCommands;
import com.j2k.skydrop.config.LootConfig;
import com.j2k.skydrop.config.ModConfig;
import com.j2k.skydrop.init.ModBlockEntities;
import com.j2k.skydrop.init.ModBlocks;
import com.j2k.skydrop.init.ModCreativeModeTabs;
import com.j2k.skydrop.init.ModEntities;
import com.j2k.skydrop.init.ModItems;
import com.j2k.skydrop.init.ModMenuTypes;
import com.j2k.skydrop.init.ModNetwork;
import com.j2k.skydrop.init.ModParticles;
import com.j2k.skydrop.network.PacketSyncLootConfig;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.PacketDistributor;
import org.slf4j.Logger;

@Mod(value="skydrop")
public class SkyDrop {
    public static final String MODID = "skydrop";
    public static final Logger LOGGER = LogUtils.getLogger();

    public SkyDrop() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModMenuTypes.register(modEventBus);
        ModEntities.register(modEventBus);
        ModCreativeModeTabs.register(modEventBus);
        ModParticles.register(modEventBus);
        ModNetwork.register();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ModConfig.SPEC);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarted);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStopping);
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerLoggedIn);
        modEventBus.addListener(this::commonSetup);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("SkyDrop Common Setup initialized.");
    }

    private void registerCommands(RegisterCommandsEvent event) {
        ModCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ModNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new PacketSyncLootConfig(LootConfig.getLootEntries()));
            LOGGER.debug("Sent loot configuration sync to player: {}", (Object)player2.m_7755_().getString());
        }
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        LOGGER.info("SkyDrop: Loading loot configuration from disk...");
        LootConfig.load();
        LOGGER.info("SkyDrop: Loot configuration loaded successfully!");
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        LOGGER.info("SkyDrop: Saving loot configuration before shutdown...");
        LootConfig.save();
        LOGGER.info("SkyDrop: Loot configuration saved successfully!");
    }
}

