/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.skydrop.block.entity;

import com.j2k.skydrop.init.ModBlockEntities;
import com.j2k.skydrop.screen.SkyDropCrateMenu;
import com.j2k.skydrop.util.MapIntegration;
import com.j2k.skydrop.world.SkyDropStats;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkyDropCrateBlockEntity
extends RandomizableContainerBlockEntity {
    private NonNullList<ItemStack> itemStacks = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private String rarityStyle = "common";
    private boolean isOpened = false;
    private long unlockTargetTime = 0L;
    private int destroyTimer = -1;
    private final Set<UUID> openedPlayers = new HashSet<UUID>();

    public SkyDropCrateBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.SKY_DROP_CRATE_BE.get(), pPos, pBlockState);
    }

    public String getRarityStyle() {
        return this.rarityStyle;
    }

    public void setRarityStyle(String style) {
        this.rarityStyle = style;
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82363_(0.0, 512.0, 0.0).m_82400_(50.0);
    }

    public void tick() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (this.destroyTimer > 0) {
            --this.destroyTimer;
            if (this.destroyTimer == 1200) {
                this.notifyNearbyPlayers((Component)Component.m_237115_((String)"skydrop.message.destroy_warning"));
            }
            if (this.destroyTimer == 0) {
                this.destroySelf();
            }
        }
    }

    private void destroySelf() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_255391_(null, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, 2.0f, false, Level.ExplosionInteraction.NONE);
            this.drops();
            serverLevel.m_7731_(this.f_58858_, Blocks.f_50016_.m_49966_(), 3);
            this.notifyNearbyPlayers((Component)Component.m_237115_((String)"skydrop.message.destroyed"));
        }
    }

    private void notifyNearbyPlayers(Component message) {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_6907_().stream().filter(p -> p.m_20275_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_()) < 2500.0).forEach(p -> p.m_213846_(message));
        }
    }

    public void setLockTime(int seconds) {
        if (this.f_58857_ != null) {
            this.unlockTargetTime = this.f_58857_.m_46467_() + (long)seconds * 20L;
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public boolean isLocked() {
        if (this.f_58857_ == null) {
            return false;
        }
        return this.f_58857_.m_46467_() < this.unlockTargetTime;
    }

    public int getSecondsRemaining() {
        if (this.f_58857_ == null) {
            return 0;
        }
        long diff = this.unlockTargetTime - this.f_58857_.m_46467_();
        if (diff <= 0L) {
            return 0;
        }
        return (int)(diff / 20L);
    }

    public boolean isOpened() {
        return this.isOpened;
    }

    public void setOpened(boolean opened) {
        Level level;
        if (opened && !this.isOpened && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_6907_().forEach(p -> MapIntegration.announceDropToPlayer(p, this.f_58858_));
        }
        this.isOpened = opened;
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void setDestroyTimer(int ticks) {
        this.destroyTimer = ticks;
        this.m_6596_();
    }

    public void addPlayerOpened(Player player) {
        Level level;
        if (this.openedPlayers.add(player.m_20148_()) && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SkyDropStats.get(serverLevel).addCapture(player.m_20148_(), player.m_7755_().getString());
        }
        this.m_6596_();
    }

    public void setLoot(NonNullList<ItemStack> items) {
        this.itemStacks = items;
        this.m_6596_();
    }

    public Component m_6820_() {
        return Component.m_237115_((String)"block.skydrop.skydrop_crate");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory inv) {
        this.addPlayerOpened(inv.f_35978_);
        return new SkyDropCrateMenu(id, inv, (BlockEntity)this, (ContainerData)new SimpleContainerData(0));
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.itemStacks;
    }

    protected void m_6520_(NonNullList<ItemStack> items) {
        this.itemStacks = items;
    }

    public int m_6643_() {
        return 27;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER && !this.f_58859_) {
            if (!this.lazyItemHandler.isPresent()) {
                this.lazyItemHandler = LazyOptional.of(() -> new InvWrapper((Container)this));
            }
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128379_("skydrop.isOpened", this.isOpened);
        pTag.m_128356_("skydrop.unlockTime", this.unlockTargetTime);
        pTag.m_128405_("skydrop.destroyTimer", this.destroyTimer);
        pTag.m_128359_("skydrop.rarityStyle", this.rarityStyle);
        long[] playerUUIDs = new long[this.openedPlayers.size() * 2];
        int idx = 0;
        for (UUID uuid : this.openedPlayers) {
            playerUUIDs[idx++] = uuid.getMostSignificantBits();
            playerUUIDs[idx++] = uuid.getLeastSignificantBits();
        }
        pTag.m_128388_("skydrop.openedPlayers", playerUUIDs);
        if (!this.m_59634_(pTag)) {
            ContainerHelper.m_18973_((CompoundTag)pTag, this.itemStacks);
        }
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.isOpened = pTag.m_128471_("skydrop.isOpened");
        this.unlockTargetTime = pTag.m_128454_("skydrop.unlockTime");
        int n = this.destroyTimer = pTag.m_128441_("skydrop.destroyTimer") ? pTag.m_128451_("skydrop.destroyTimer") : -1;
        if (pTag.m_128441_("skydrop.rarityStyle")) {
            this.rarityStyle = pTag.m_128461_("skydrop.rarityStyle");
        }
        long[] playerUUIDs = pTag.m_128467_("skydrop.openedPlayers");
        this.openedPlayers.clear();
        for (int i = 0; i < playerUUIDs.length; i += 2) {
            this.openedPlayers.add(new UUID(playerUUIDs[i], playerUUIDs[i + 1]));
        }
        this.itemStacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(pTag)) {
            ContainerHelper.m_18980_((CompoundTag)pTag, this.itemStacks);
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void drops() {
        if (this.f_58857_ != null) {
            Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)this);
        }
    }
}

