/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.skydrop.client.renderer;

import com.j2k.skydrop.block.entity.SkyDropCrateBlockEntity;
import com.j2k.skydrop.client.model.SkyDropCrateModel;
import com.j2k.skydrop.config.LootConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class SkyDropCrateRenderer
implements BlockEntityRenderer<SkyDropCrateBlockEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("skydrop", "textures/entity/crate_detail_skin.png");
    private static final ResourceLocation BEAM_LOCATION = new ResourceLocation("textures/entity/beacon_beam.png");
    private final SkyDropCrateModel model;
    private final BlockEntityRendererProvider.Context context;
    private final Random random = new Random();

    public SkyDropCrateRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new SkyDropCrateModel(context.m_173582_(SkyDropCrateModel.LAYER_LOCATION));
        this.context = context;
    }

    public boolean shouldRender(SkyDropCrateBlockEntity blockEntity, Vec3 cameraPos) {
        return Vec3.m_82512_((Vec3i)blockEntity.m_58899_()).m_82509_((Position)cameraPos, 1024.0);
    }

    public void render(SkyDropCrateBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        pPoseStack.m_85836_();
        pPoseStack.m_85837_(0.5, 1.5, 0.5);
        pPoseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        VertexConsumer consumer = pBufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE));
        this.model.m_7695_(pPoseStack, consumer, pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        pPoseStack.m_85849_();
        if (!pBlockEntity.isOpened()) {
            long gameTime = pBlockEntity.m_58904_().m_46467_();
            float time = (float)gameTime + pPartialTick;
            if (LootConfig.isBeamEnabled()) {
                pPoseStack.m_85836_();
                float pulse = Mth.m_14031_((float)(time * 0.1f)) * 0.15f + 0.75f;
                String style = pBlockEntity.getRarityStyle();
                float[] color = new float[]{(float)LootConfig.getBeamColorR() / 255.0f, (float)LootConfig.getBeamColorG() / 255.0f, (float)LootConfig.getBeamColorB() / 255.0f};
                if ("legendary".equals(style)) {
                    color = new float[]{1.0f, 0.7f, 0.1f};
                } else if ("epic".equals(style)) {
                    color = new float[]{0.7f, 0.0f, 1.0f};
                } else if ("rare".equals(style)) {
                    color = new float[]{0.1f, 0.6f, 1.0f};
                }
                BeaconRenderer.m_112184_((PoseStack)pPoseStack, (MultiBufferSource)pBufferSource, (ResourceLocation)BEAM_LOCATION, (float)pPartialTick, (float)pulse, (long)gameTime, (int)0, (int)512, (float[])color, (float)0.15f, (float)0.22f);
                pPoseStack.m_85849_();
                if (gameTime % 3L == 0L) {
                    double px = (double)pBlockEntity.m_58899_().m_123341_() + 0.5 + (this.random.nextDouble() - 0.5) * 0.4;
                    double py = (double)pBlockEntity.m_58899_().m_123342_() + 1.2;
                    double pz = (double)pBlockEntity.m_58899_().m_123343_() + 0.5 + (this.random.nextDouble() - 0.5) * 0.4;
                    pBlockEntity.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, px, py, pz, 0.0, 0.12, 0.0);
                }
            }
            if (pBlockEntity.isLocked()) {
                int seconds = pBlockEntity.getSecondsRemaining();
                String timerText = String.format("%02d:%02d", seconds / 60, seconds % 60);
                String labelKey = "skydrop.label.locked";
                int labelColor = 0xFF4444;
                String style = pBlockEntity.getRarityStyle();
                if ("legendary".equals(style)) {
                    labelKey = "skydrop.label.legendary";
                    labelColor = 0xFFAA00;
                } else if ("epic".equals(style)) {
                    labelKey = "skydrop.label.epic";
                    labelColor = 0xFF55FF;
                } else if ("rare".equals(style)) {
                    labelKey = "skydrop.label.rare";
                    labelColor = 0x55FFFF;
                }
                String labelText = Component.m_237115_((String)labelKey).getString();
                this.renderLabel(pPoseStack, pBufferSource, pPackedLight, labelText, labelColor, 0.6f, 1.5f);
                this.renderLabel(pPoseStack, pBufferSource, pPackedLight, timerText, 0xFFFFFF, 0.35f, 1.1f);
            }
        }
    }

    private void renderLabel(PoseStack stack, MultiBufferSource buffer, int light, String text, int color, float yOffset, float scaleMod) {
        stack.m_85836_();
        stack.m_85837_(0.5, 1.2 + (double)yOffset, 0.5);
        stack.m_252781_(this.context.m_173581_().f_112249_.m_253121_());
        stack.m_85841_(-0.025f * scaleMod, -0.025f * scaleMod, 0.025f * scaleMod);
        Matrix4f matrix4f = stack.m_85850_().m_252922_();
        Font font = Minecraft.m_91087_().f_91062_;
        float xOffset = (float)(-font.m_92895_(text)) / 2.0f;
        int fullBright = LightTexture.m_109885_((int)15, (int)15);
        font.m_271703_(text, xOffset, 0.0f, 0x20000000, false, matrix4f, buffer, Font.DisplayMode.NORMAL, 0, fullBright);
        font.m_271703_(text, xOffset, 0.0f, color, false, matrix4f, buffer, Font.DisplayMode.SEE_THROUGH, 0, fullBright);
        font.m_271703_(text, xOffset, 0.0f, color, false, matrix4f, buffer, Font.DisplayMode.NORMAL, 0, fullBright);
        stack.m_85849_();
    }
}

