/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.skydrop.client.renderer;

import com.j2k.skydrop.client.model.ModModelLayers;
import com.j2k.skydrop.client.model.SkyDropAirModel;
import com.j2k.skydrop.entity.SkyDropEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class SkyDropEntityRenderer
extends EntityRenderer<SkyDropEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("skydrop", "textures/entity/pubg_ultra_skin.png");
    private final SkyDropAirModel model;

    public SkyDropEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new SkyDropAirModel(context.m_174023_(ModModelLayers.SKY_DROP_AIR_LAYER));
    }

    public boolean shouldRender(SkyDropEntity pLivingEntity, Frustum pCamera, double pCamX, double pCamY, double pCamZ) {
        return true;
    }

    public void render(SkyDropEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.5, -0.5);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        float lerpYaw = Mth.m_14189_((float)partialTicks, (float)entity.f_19859_, (float)entity.m_146908_());
        poseStack.m_252781_(Axis.f_252436_.m_252977_(lerpYaw));
        float time = (float)entity.f_19797_ + partialTicks;
        if (!entity.m_20096_()) {
            float swayX = Mth.m_14031_((float)(time * 0.05f)) * 5.0f;
            float swayZ = Mth.m_14089_((float)(time * 0.043f)) * 5.0f;
            poseStack.m_252781_(Axis.f_252529_.m_252977_(swayX));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(swayZ));
        }
        float scale = 1.0f;
        poseStack.m_85841_(scale, scale, scale);
        VertexConsumer vertexconsumer = buffer.m_6299_(this.model.m_103119_(this.getTextureLocation(entity)));
        this.model.m_7695_(poseStack, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(SkyDropEntity pEntity) {
        return TEXTURE;
    }
}

