/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.skydrop.command;

import com.j2k.skydrop.config.LootConfig;
import com.j2k.skydrop.config.ModConfig;
import com.j2k.skydrop.entity.SkyDropEntity;
import com.j2k.skydrop.init.ModNetwork;
import com.j2k.skydrop.network.PacketSyncLootConfig;
import com.j2k.skydrop.screen.LootEditorMenu;
import com.j2k.skydrop.world.SkyDropStats;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Random;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;

public class ModCommands {
    private static final Random random = new Random();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"skydrop").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"spawn").requires(s -> s.m_6761_(2))).executes(ctx -> ModCommands.spawnDrop((CommandSourceStack)ctx.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"multi").requires(s -> s.m_6761_(2))).executes(ctx -> ModCommands.spawnMulti((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"top").executes(ctx -> ModCommands.showTop((CommandSourceStack)ctx.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"edit").requires(s -> s.m_6761_(2))).executes(ctx -> ModCommands.openEditor((CommandSourceStack)ctx.getSource()))));
    }

    private static int spawnDrop(CommandSourceStack source) {
        try {
            ServerPlayer player = source.m_81375_();
            Vec3 pos = player.m_20182_();
            double configY = ((Integer)ModConfig.DROP_HEIGHT.get()).intValue();
            double spawnY = pos.f_82480_ > configY - 20.0 ? pos.f_82480_ + 50.0 : configY;
            SkyDropEntity drop = new SkyDropEntity(player.m_9236_(), pos.f_82479_, spawnY, pos.f_82481_);
            player.m_9236_().m_7967_((Entity)drop);
            source.m_288197_(() -> Component.m_237110_((String)"skydrop.command.spawn_success", (Object[])new Object[]{(int)spawnY}), true);
            return 1;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static int spawnMulti(CommandSourceStack source) {
        try {
            ServerPlayer player = source.m_81375_();
            source.m_288197_(() -> Component.m_237115_((String)"skydrop.command.multi_spawn"), true);
            double configY = ((Integer)ModConfig.DROP_HEIGHT.get()).intValue();
            double baseSpawnY = player.m_20186_() > configY - 20.0 ? player.m_20186_() + 50.0 : configY;
            for (int i = 0; i < 5; ++i) {
                int offX = random.nextInt(160) - 80;
                int offZ = random.nextInt(160) - 80;
                SkyDropEntity drop = new SkyDropEntity(player.m_9236_(), player.m_20185_() + (double)offX, baseSpawnY, player.m_20189_() + (double)offZ);
                player.m_9236_().m_7967_((Entity)drop);
            }
            return 1;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static int showTop(CommandSourceStack source) {
        if (source.m_81372_().f_46443_) {
            return 0;
        }
        SkyDropStats stats = SkyDropStats.get(source.m_81372_());
        source.m_288197_(() -> Component.m_237110_((String)"skydrop.command.top_header", (Object[])new Object[]{stats.getTopList()}), false);
        return 1;
    }

    private static int openEditor(CommandSourceStack source) {
        try {
            ServerPlayer player = source.m_81375_();
            ModNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketSyncLootConfig(LootConfig.getLootEntries()));
            SimpleMenuProvider container = new SimpleMenuProvider((id, inv, p) -> {
                SimpleContainerData data = new SimpleContainerData(13);
                data.m_8050_(0, LootConfig.getMinItems());
                data.m_8050_(1, LootConfig.getMaxItems());
                data.m_8050_(8, LootConfig.getLockTime());
                data.m_8050_(9, LootConfig.getDestroyTime());
                data.m_8050_(10, LootConfig.getBeamColorR());
                data.m_8050_(11, LootConfig.getBeamColorG());
                data.m_8050_(12, LootConfig.getBeamColorB());
                return new LootEditorMenu(id, inv, (ContainerData)data);
            }, (Component)Component.m_237115_((String)"skydrop.gui.editor_title"));
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)container);
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }
}

