/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.skydrop.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;

public class LootConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_DIR = FMLPaths.CONFIGDIR.get().resolve("skydrop");
    private static String currentConfigName = "loot_config.json";
    private static int minItems = 4;
    private static int maxItems = 7;
    private static int lockTime = 30;
    private static int destroyTime = 900;
    private static boolean allowEmpty = false;
    private static boolean allowDuplicates = true;
    private static boolean notifySpawn = true;
    private static boolean enableBeam = true;
    private static int beamColorR = 255;
    private static int beamColorG = 0;
    private static int beamColorB = 0;
    private static final List<LootEntry> lootEntries = new ArrayList<LootEntry>();

    public static void load() {
        LootConfig.load(currentConfigName);
    }

    public static void load(String name) {
        block15: {
            currentConfigName = name;
            Path file = CONFIG_DIR.resolve(name);
            if (!Files.exists(file, new LinkOption[0])) {
                LootConfig.save();
                return;
            }
            try (BufferedReader reader = Files.newBufferedReader(file);){
                JsonObject root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                if (root.has("settings")) {
                    JsonObject s = root.getAsJsonObject("settings");
                    minItems = s.has("minItems") ? s.get("minItems").getAsInt() : 4;
                    maxItems = s.has("maxItems") ? s.get("maxItems").getAsInt() : 7;
                    lockTime = s.has("lockTime") ? s.get("lockTime").getAsInt() : 30;
                    destroyTime = s.has("destroyTime") ? s.get("destroyTime").getAsInt() : 900;
                    allowEmpty = s.has("allowEmpty") ? s.get("allowEmpty").getAsBoolean() : false;
                    allowDuplicates = s.has("allowDuplicates") ? s.get("allowDuplicates").getAsBoolean() : true;
                    notifySpawn = !s.has("notifySpawn") || s.get("notifySpawn").getAsBoolean();
                    boolean bl = enableBeam = !s.has("enableBeam") || s.get("enableBeam").getAsBoolean();
                    if (s.has("beamColor")) {
                        JsonObject c = s.getAsJsonObject("beamColor");
                        beamColorR = c.get("r").getAsInt();
                        beamColorG = c.get("g").getAsInt();
                        beamColorB = c.get("b").getAsInt();
                    }
                }
                lootEntries.clear();
                if (!root.has("items")) break block15;
                for (JsonElement e : root.getAsJsonArray("items")) {
                    JsonObject o = e.getAsJsonObject();
                    ResourceLocation id = new ResourceLocation(o.get("id").getAsString());
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
                    if (item == null || item == Items.f_41852_) continue;
                    ItemStack stack = new ItemStack((ItemLike)item);
                    if (o.has("nbt")) {
                        try {
                            stack.m_41751_(TagParser.m_129359_((String)o.get("nbt").getAsString()));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    LootEntry entry = new LootEntry(stack);
                    entry.minCount = o.has("minCount") ? o.get("minCount").getAsInt() : 1;
                    entry.maxCount = o.has("maxCount") ? o.get("maxCount").getAsInt() : entry.minCount;
                    entry.weight = o.has("weight") ? o.get("weight").getAsInt() : 10;
                    entry.rarity = o.has("rarity") ? o.get("rarity").getAsString() : "common";
                    entry.enabled = !o.has("enabled") || o.get("enabled").getAsBoolean();
                    lootEntries.add(entry);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void save() {
        try {
            Path file = CONFIG_DIR.resolve(currentConfigName);
            JsonObject root = new JsonObject();
            JsonObject s = new JsonObject();
            s.addProperty("minItems", (Number)minItems);
            s.addProperty("maxItems", (Number)maxItems);
            s.addProperty("lockTime", (Number)lockTime);
            s.addProperty("destroyTime", (Number)destroyTime);
            s.addProperty("allowEmpty", Boolean.valueOf(allowEmpty));
            s.addProperty("allowDuplicates", Boolean.valueOf(allowDuplicates));
            s.addProperty("notifySpawn", Boolean.valueOf(notifySpawn));
            s.addProperty("enableBeam", Boolean.valueOf(enableBeam));
            JsonObject c = new JsonObject();
            c.addProperty("r", (Number)beamColorR);
            c.addProperty("g", (Number)beamColorG);
            c.addProperty("b", (Number)beamColorB);
            s.add("beamColor", (JsonElement)c);
            root.add("settings", (JsonElement)s);
            JsonArray items = new JsonArray();
            for (LootEntry e : lootEntries) {
                JsonObject o = new JsonObject();
                o.addProperty("id", ForgeRegistries.ITEMS.getKey((Object)e.item).toString());
                o.addProperty("minCount", (Number)e.minCount);
                o.addProperty("maxCount", (Number)e.maxCount);
                o.addProperty("weight", (Number)e.weight);
                o.addProperty("rarity", e.rarity);
                o.addProperty("enabled", Boolean.valueOf(e.enabled));
                if (e.stack.m_41782_()) {
                    o.addProperty("nbt", e.stack.m_41783_().toString());
                }
                items.add((JsonElement)o);
            }
            root.add("items", (JsonElement)items);
            try (BufferedWriter w = Files.newBufferedWriter(file, new OpenOption[0]);){
                GSON.toJson((JsonElement)root, (Appendable)w);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static NonNullList<ItemStack> generateLoot(RandomSource random) {
        NonNullList result = NonNullList.m_122779_();
        List active = lootEntries.stream().filter(e -> e.enabled).collect(Collectors.toList());
        if (active.isEmpty()) {
            return result;
        }
        int totalWeight = active.stream().mapToInt(e -> e.weight).sum();
        int count = random.m_216339_(minItems, maxItems + 1);
        if (count <= 0 && !allowEmpty) {
            count = 1;
        }
        HashSet<Item> addedItems = new HashSet<Item>();
        block0: for (int i = 0; i < count; ++i) {
            int roll = random.m_188503_(totalWeight);
            int curr = 0;
            for (LootEntry entry : active) {
                if (roll >= (curr += entry.weight) || !allowDuplicates && addedItems.contains(entry.item)) continue;
                result.add((Object)entry.createStack(random));
                addedItems.add(entry.item);
                continue block0;
            }
        }
        return result;
    }

    public static void createNewConfig(String name) {
        if (!((String)name).endsWith(".json")) {
            name = (String)name + ".json";
        }
        currentConfigName = name;
        lootEntries.clear();
        LootConfig.save();
    }

    public static int getMinItems() {
        return minItems;
    }

    public static void setMinItems(int v) {
        minItems = v;
    }

    public static int getMaxItems() {
        return maxItems;
    }

    public static void setMaxItems(int v) {
        maxItems = v;
    }

    public static int getLockTime() {
        return lockTime;
    }

    public static void setLockTime(int v) {
        lockTime = v;
    }

    public static int getDestroyTime() {
        return destroyTime;
    }

    public static void setDestroyTime(int v) {
        destroyTime = v;
    }

    public static boolean getAllowEmpty() {
        return allowEmpty;
    }

    public static void setAllowEmpty(boolean v) {
        allowEmpty = v;
    }

    public static boolean getAllowDuplicates() {
        return allowDuplicates;
    }

    public static void setAllowDuplicates(boolean v) {
        allowDuplicates = v;
    }

    public static boolean shouldNotifySpawn() {
        return notifySpawn;
    }

    public static void setNotifySpawn(boolean v) {
        notifySpawn = v;
    }

    public static boolean isBeamEnabled() {
        return enableBeam;
    }

    public static void setEnableBeam(boolean v) {
        enableBeam = v;
    }

    public static int getBeamColorR() {
        return beamColorR;
    }

    public static void setBeamColorR(int v) {
        beamColorR = Mth.m_14045_((int)v, (int)0, (int)255);
    }

    public static int getBeamColorG() {
        return beamColorG;
    }

    public static void setBeamColorG(int v) {
        beamColorG = Mth.m_14045_((int)v, (int)0, (int)255);
    }

    public static int getBeamColorB() {
        return beamColorB;
    }

    public static void setBeamColorB(int v) {
        beamColorB = Mth.m_14045_((int)v, (int)0, (int)255);
    }

    public static List<LootEntry> getLootEntries() {
        return lootEntries;
    }

    public static String getCurrentConfigName() {
        return currentConfigName;
    }

    public static void addLootEntry(LootEntry e) {
        lootEntries.add(e);
        LootConfig.save();
    }

    public static void removeLootEntry(Item i) {
        lootEntries.removeIf(e -> e.item == i);
        LootConfig.save();
    }

    public static void updateLootEntry(Item i, LootEntry n) {
        for (int k = 0; k < lootEntries.size(); ++k) {
            if (LootConfig.lootEntries.get((int)k).item != i) continue;
            lootEntries.set(k, n);
            LootConfig.save();
            return;
        }
    }

    public static List<String> getAvailableConfigs() {
        List<String> list;
        block8: {
            Stream<Path> s = Files.list(CONFIG_DIR);
            try {
                list = s.filter(f -> f.toString().endsWith(".json")).map(p -> p.getFileName().toString()).collect(Collectors.toList());
                if (s == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return Collections.singletonList("loot_config.json");
                }
            }
            s.close();
        }
        return list;
    }

    static {
        try {
            if (!Files.exists(CONFIG_DIR, new LinkOption[0])) {
                Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LootConfig.load(currentConfigName);
    }

    public static class LootEntry {
        public Item item;
        public ItemStack stack;
        public int minCount = 1;
        public int maxCount = 1;
        public int weight = 10;
        public String rarity = "common";
        public boolean enabled = true;

        public LootEntry(Item item) {
            this.item = item;
            this.stack = new ItemStack((ItemLike)item);
        }

        public LootEntry(ItemStack stack) {
            this.stack = stack.m_41777_();
            this.item = stack.m_41720_();
        }

        public ItemStack createStack(RandomSource r) {
            ItemStack result = this.stack.m_41777_();
            int count = this.minCount;
            if (this.maxCount > this.minCount) {
                count = r.m_216339_(this.minCount, this.maxCount + 1);
            }
            result.m_41764_(Mth.m_14045_((int)count, (int)1, (int)this.item.m_41459_()));
            return result;
        }
    }
}

