/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.skydrop.entity;

import com.j2k.skydrop.config.ModConfig;
import com.j2k.skydrop.entity.SkyDropEntity;
import com.j2k.skydrop.init.ModEntities;
import com.j2k.skydrop.init.ModItems;
import com.j2k.skydrop.init.ModParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class SignalGrenadeEntity
extends ThrowableItemProjectile {
    private boolean hasLanded = false;
    private int fuseTimer = 200;

    public SignalGrenadeEntity(EntityType<? extends ThrowableItemProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public SignalGrenadeEntity(Level pLevel, LivingEntity pShooter) {
        super((EntityType)ModEntities.SIGNAL_GRENADE.get(), pShooter, pLevel);
    }

    protected Item m_7881_() {
        return (Item)ModItems.SIGNAL_GRENADE.get();
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!this.m_9236_().f_46443_) {
            this.m_20256_(Vec3.f_82478_);
            this.m_20242_(true);
            this.m_6034_(this.m_20185_(), this.m_20186_() + 0.1, this.m_20189_());
            this.hasLanded = true;
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.hasLanded) {
            if (!this.m_20068_()) {
                this.m_20242_(true);
            }
            this.m_20256_(Vec3.f_82478_);
            if (!this.m_9236_().f_46443_) {
                --this.fuseTimer;
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.THICK_SMOKE.get()), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 5, 0.1, 0.5, 0.1, 0.1);
                if (this.fuseTimer % 2 == 0) {
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123777_, this.m_20185_(), this.m_20186_() + 0.3, this.m_20189_(), 2, 0.05, 0.5, 0.05, 0.05);
                }
                if (this.fuseTimer <= 0) {
                    this.spawnDrop();
                    this.m_146870_();
                }
            }
        }
    }

    private void spawnDrop() {
        int x = this.m_20183_().m_123341_();
        int z = this.m_20183_().m_123343_();
        int surfaceY = this.m_9236_().m_6924_(Heightmap.Types.WORLD_SURFACE, x, z);
        double spawnY = Math.max(surfaceY + 100, (Integer)ModConfig.DROP_HEIGHT.get());
        if (spawnY > 319.0) {
            spawnY = 319.0;
        }
        SkyDropEntity drop = new SkyDropEntity(this.m_9236_(), (double)x + 0.5, spawnY, (double)z + 0.5);
        this.m_9236_().m_7967_((Entity)drop);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("Landed", this.hasLanded);
        pCompound.m_128405_("Fuse", this.fuseTimer);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.hasLanded = pCompound.m_128471_("Landed");
        this.fuseTimer = pCompound.m_128451_("Fuse");
        if (this.hasLanded) {
            this.m_20242_(true);
            this.m_20256_(Vec3.f_82478_);
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

