/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.skydrop.entity;

import com.j2k.skydrop.block.entity.SkyDropCrateBlockEntity;
import com.j2k.skydrop.config.LootConfig;
import com.j2k.skydrop.init.ModBlocks;
import com.j2k.skydrop.init.ModEntities;
import com.j2k.skydrop.init.ModParticles;
import com.j2k.skydrop.util.LuckSystem;
import com.j2k.skydrop.util.MapIntegration;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class SkyDropEntity
extends Entity {
    private static final EntityDataAccessor<Float> DATA_GRAVITY_MODIFIER = SynchedEntityData.m_135353_(SkyDropEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> DATA_PARACHUTE_BROKEN = SynchedEntityData.m_135353_(SkyDropEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final float windOffset;
    private BlockPos spawnPosition;

    public SkyDropEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.windOffset = this.f_19796_.m_188501_() * 100.0f;
    }

    public SkyDropEntity(Level pLevel, double x, double y, double z) {
        this((EntityType)ModEntities.SKY_DROP_ENTITY.get(), pLevel);
        this.m_6034_(x, y, z);
        this.spawnPosition = new BlockPos((int)x, (int)y, (int)z);
        this.f_19804_.m_135381_(DATA_GRAVITY_MODIFIER, (Object)Float.valueOf(0.8f + pLevel.f_46441_.m_188501_() * 0.4f));
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_GRAVITY_MODIFIER, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(DATA_PARACHUTE_BROKEN, (Object)false);
    }

    public boolean isParachuteBroken() {
        return (Boolean)this.f_19804_.m_135370_(DATA_PARACHUTE_BROKEN);
    }

    public float getGravityModifier() {
        return ((Float)this.f_19804_.m_135370_(DATA_GRAVITY_MODIFIER)).floatValue();
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (!this.m_9236_().f_46443_ && !this.isParachuteBroken() && pSource.m_269533_(DamageTypeTags.f_268524_)) {
            this.f_19804_.m_135381_(DATA_PARACHUTE_BROKEN, (Object)true);
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12639_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_(), this.m_20186_() + 3.0, this.m_20189_(), 10, 0.5, 0.5, 0.5, 0.1);
            return true;
        }
        return super.m_6469_(pSource, pAmount);
    }

    public boolean m_6087_() {
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.spawnClientEffects();
        }
        if (this.m_9236_().f_46443_ && this.m_20186_() > 180.0) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_(), this.m_20186_() + 4.0, this.m_20189_(), 0.0, 0.1, 0.0);
        }
        Vec3 currentMotion = this.m_20184_();
        double targetY = -0.3 * (double)this.getGravityModifier();
        if (this.isParachuteBroken()) {
            targetY = -1.5;
        }
        double time = (double)this.f_19797_ * 0.01;
        double windMultiplier = 0.12;
        if (this.m_9236_().m_46471_()) {
            windMultiplier = 0.4;
        }
        if (this.m_9236_().m_46470_()) {
            windMultiplier = 0.7;
        }
        double windX = Math.sin(time + (double)this.windOffset) * windMultiplier;
        double windZ = Math.cos(time * 0.7 + (double)this.windOffset) * windMultiplier;
        double newX = Mth.m_14139_((double)0.05, (double)currentMotion.f_82479_, (double)windX);
        double newY = Mth.m_14139_((double)0.1, (double)currentMotion.f_82480_, (double)targetY);
        double newZ = Mth.m_14139_((double)0.05, (double)currentMotion.f_82481_, (double)windZ);
        if (this.m_20069_()) {
            if (!this.isParachuteBroken() && !this.m_9236_().f_46443_) {
                this.f_19804_.m_135381_(DATA_PARACHUTE_BROKEN, (Object)true);
            }
            newX *= 0.8;
            newZ *= 0.8;
            double surfaceY = (double)((int)this.m_20186_()) + 0.85;
            newY = this.m_20186_() < surfaceY ? 0.1 : -0.05;
        }
        this.m_20334_(newX, newY, newZ);
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (newX * newX + newZ * newZ > 1.0E-4) {
            float targetYaw = (float)(Mth.m_14136_((double)newX, (double)newZ) * 57.29577951308232);
            this.m_146922_(Mth.m_14148_((float)this.m_146908_(), (float)targetYaw, (float)5.0f));
        }
        if (!this.m_9236_().f_46443_) {
            this.handleCollisions();
            if (this.m_20186_() < -64.0) {
                this.m_146870_();
            }
        }
    }

    private void handleCollisions() {
        BlockPos pos = this.m_20183_();
        BlockPos below = pos.m_7495_();
        BlockState stateBelow = this.m_9236_().m_8055_(below);
        if (stateBelow.m_204336_(BlockTags.f_13035_) || stateBelow.m_204336_(BlockTags.f_13049_)) {
            this.m_9236_().m_46961_(below, true);
        }
        boolean isFloating = this.m_20069_();
        if (this.m_20096_() || isFloating && this.isParachuteBroken() && Math.abs(this.m_20184_().f_82480_) < 0.1) {
            boolean hasSupport;
            BlockPos landPos = pos;
            if (isFloating) {
                while (this.m_9236_().m_8055_(landPos).m_60713_(Blocks.f_49990_)) {
                    landPos = landPos.m_7494_();
                }
                landPos = landPos.m_7495_();
            } else if (!this.m_9236_().m_8055_(landPos).m_247087_()) {
                landPos = landPos.m_7494_();
            }
            BlockState support = this.m_9236_().m_8055_(landPos.m_7495_());
            boolean bl = hasSupport = !support.m_60795_();
            if (this.m_9236_().m_46739_(landPos) && (this.m_9236_().m_8055_(landPos).m_247087_() || this.m_9236_().m_6425_(landPos).m_76170_()) && hasSupport) {
                this.placeCrate(landPos);
                if (!isFloating) {
                    this.createCrater(landPos);
                }
                if (this.isParachuteBroken() && !isFloating) {
                    this.createBigCrater(landPos);
                }
                this.createShockwave(landPos);
                this.spawnLandEffects(landPos);
                this.announceDropLanded(landPos);
                this.m_146870_();
            }
        }
    }

    private void createShockwave(BlockPos pos) {
        List entities = this.m_9236_().m_45976_(LivingEntity.class, new AABB(pos).m_82400_(10.0));
        for (LivingEntity entity : entities) {
            double dz;
            double dist = Math.sqrt(entity.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
            if (!(dist < 10.0)) continue;
            double strength = (10.0 - dist) * 0.2;
            double dx = entity.m_20185_() - (double)pos.m_123341_();
            double norm = Math.sqrt(dx * dx + (dz = entity.m_20189_() - (double)pos.m_123343_()) * dz);
            if (!(norm > 0.0)) continue;
            entity.m_5997_(dx / norm * strength, 0.5, dz / norm * strength);
            entity.m_6469_(this.m_9236_().m_269111_().m_269036_(null, null), 1.0f);
        }
    }

    private void createCrater(BlockPos center) {
        for (BlockPos p : BlockPos.m_121940_((BlockPos)center.m_7918_(-2, -2, -2), (BlockPos)center.m_7918_(2, 0, 2))) {
            if (!(p.m_123331_((Vec3i)center) <= 4.0)) continue;
            BlockState st = this.m_9236_().m_8055_(p);
            if (st.m_60713_(Blocks.f_50440_) || st.m_60713_(Blocks.f_50493_)) {
                this.m_9236_().m_7731_(p, Blocks.f_50546_.m_49966_(), 3);
                continue;
            }
            if (!st.m_204336_(BlockTags.f_13035_) && !st.m_204336_(BlockTags.f_144279_)) continue;
            this.m_9236_().m_46961_(p, false);
        }
    }

    private void createBigCrater(BlockPos center) {
        this.m_9236_().m_254849_((Entity)this, (double)center.m_123341_(), (double)center.m_123342_(), (double)center.m_123343_(), 2.0f, Level.ExplosionInteraction.BLOCK);
    }

    private void placeCrate(BlockPos pos) {
        BlockEntity be;
        BlockState state = ((Block)ModBlocks.SKY_DROP_CRATE.get()).m_49966_();
        if (this.m_9236_().m_6425_(pos).m_76170_()) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
        }
        if (this.m_9236_().m_7731_(pos, state, 3) && (be = this.m_9236_().m_7702_(pos)) instanceof SkyDropCrateBlockEntity) {
            boolean destroyedByImpact;
            SkyDropCrateBlockEntity crate = (SkyDropCrateBlockEntity)be;
            NonNullList<ItemStack> generatedLoot = LootConfig.generateLoot(this.m_9236_().m_213780_());
            ArrayList<ItemStack> lootList = new ArrayList<ItemStack>();
            boolean bl = destroyedByImpact = this.isParachuteBroken() && !this.m_20069_();
            if (destroyedByImpact) {
                int removeCount = generatedLoot.size() / 2;
                for (int k = 0; k < removeCount; ++k) {
                    if (generatedLoot.isEmpty()) continue;
                    generatedLoot.remove(0);
                }
            }
            for (int i = 0; i < generatedLoot.size() && i < crate.m_6643_(); ++i) {
                ItemStack stack = ((ItemStack)generatedLoot.get(i)).m_41777_();
                if (stack.m_41741_() == 1) {
                    stack.m_41764_(1);
                }
                crate.m_6836_(i, stack);
                lootList.add(stack);
            }
            String style = LuckSystem.getLuckStyle(lootList);
            crate.setRarityStyle(style);
            crate.setLockTime(LootConfig.getLockTime());
            crate.setDestroyTimer(LootConfig.getDestroyTime() * 60 * 20);
            crate.m_6596_();
            this.m_9236_().m_7260_(pos, crate.m_58900_(), crate.m_58900_(), 3);
        }
    }

    private void announceDropLanded(BlockPos landPos) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.spawnPosition != null) {
                int driftX = landPos.m_123341_() - this.spawnPosition.m_123341_();
                int driftZ = landPos.m_123343_() - this.spawnPosition.m_123343_();
                double driftDistance = Math.sqrt(driftX * driftX + driftZ * driftZ);
                serverLevel.m_6907_().stream().filter(p -> p.m_20275_((double)landPos.m_123341_(), (double)landPos.m_123342_(), (double)landPos.m_123343_()) < 1000000.0).forEach(p -> MapIntegration.announceDropLanded(p, landPos, driftDistance));
            }
        }
    }

    private void spawnClientEffects() {
        if (this.f_19797_ % 2 == 0) {
            this.m_9236_().m_7106_((ParticleOptions)ModParticles.THICK_SMOKE.get(), this.m_20185_(), this.m_20186_() + 2.5, this.m_20189_(), 0.0, 0.05, 0.0);
        }
    }

    private void spawnLandEffects(BlockPos pos) {
        ServerLevel sl = (ServerLevel)this.m_9236_();
        sl.m_5594_(null, pos, SoundEvents.f_11913_, SoundSource.BLOCKS, 2.0f, 1.0f);
        sl.m_8767_((ParticleOptions)ParticleTypes.f_123813_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        sl.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.THICK_SMOKE.get()), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, 20, 1.0, 0.5, 1.0, 0.05);
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128441_("GravityModifier")) {
            this.f_19804_.m_135381_(DATA_GRAVITY_MODIFIER, (Object)Float.valueOf(tag.m_128457_("GravityModifier")));
        }
        if (tag.m_128441_("SpawnX")) {
            this.spawnPosition = new BlockPos(tag.m_128451_("SpawnX"), tag.m_128451_("SpawnY"), tag.m_128451_("SpawnZ"));
        }
        if (tag.m_128441_("ParachuteBroken")) {
            this.f_19804_.m_135381_(DATA_PARACHUTE_BROKEN, (Object)tag.m_128471_("ParachuteBroken"));
        }
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128350_("GravityModifier", this.getGravityModifier());
        if (this.spawnPosition != null) {
            tag.m_128405_("SpawnX", this.spawnPosition.m_123341_());
            tag.m_128405_("SpawnY", this.spawnPosition.m_123342_());
            tag.m_128405_("SpawnZ", this.spawnPosition.m_123343_());
        }
        tag.m_128379_("ParachuteBroken", this.isParachuteBroken());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

