/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.skydrop.event;

import com.j2k.skydrop.SkyDrop;
import com.j2k.skydrop.config.ModConfig;
import com.j2k.skydrop.entity.SkyDropEntity;
import com.j2k.skydrop.util.MapIntegration;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="skydrop")
public class WorldTickHandler {
    private static final Random random = new Random();

    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        if (event.side.isClient() || event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.level.m_46472_() != Level.f_46428_) {
            return;
        }
        if (!((Boolean)ModConfig.SHOULD_SPAWN_AUTOMATICALLY.get()).booleanValue()) {
            return;
        }
        long gameTime = event.level.m_46467_();
        int interval = (Integer)ModConfig.DROP_INTERVAL.get();
        if (interval < 1200) {
            interval = 12000;
        }
        if (gameTime % (long)interval == 0L) {
            WorldTickHandler.spawnRandomDrop((ServerLevel)event.level);
        }
    }

    private static void spawnRandomDrop(ServerLevel level) {
        double z;
        List players = level.m_6907_();
        if (players.isEmpty()) {
            return;
        }
        ServerPlayer randomPlayer = (ServerPlayer)players.get(random.nextInt(players.size()));
        int radius = (Integer)ModConfig.DROP_RADIUS.get();
        int offsetX = random.nextInt(radius * 2) - radius;
        int offsetZ = random.nextInt(radius * 2) - radius;
        double x = randomPlayer.m_20185_() + (double)offsetX;
        int surfaceY = level.m_6924_(Heightmap.Types.WORLD_SURFACE, (int)x, (int)(z = randomPlayer.m_20189_() + (double)offsetZ));
        double spawnY = Math.max(surfaceY + 120, (Integer)ModConfig.DROP_HEIGHT.get());
        if (spawnY > 310.0) {
            spawnY = 310.0;
        }
        SkyDropEntity drop = new SkyDropEntity((Level)level, x, spawnY, z);
        level.m_7967_((Entity)drop);
        BlockPos spawnPos = new BlockPos((int)x, (int)spawnY, (int)z);
        for (ServerPlayer player : players) {
            double distance = player.m_20275_(x, spawnY, z);
            if (!(distance < 1000000.0)) continue;
            MapIntegration.announceDropSpawned(player, spawnPos);
        }
        SkyDrop.LOGGER.info("Automatic SkyDrop spawned at [{}, {}, {}] near player {}", new Object[]{(int)x, (int)spawnY, (int)z, randomPlayer.m_7755_().getString()});
    }
}

