/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.skydrop.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="skydrop")
public class AdrenalineItem
extends Item {
    private static final String NBT_DOSE_COUNT = "skydrop.adrenaline_doses";
    private static final String NBT_ACTIVE_TIME = "skydrop.adrenaline_active_ticks";

    public AdrenalineItem(Item.Properties pProperties) {
        super(pProperties.m_41487_(64));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.skydrop.adrenaline.tooltip").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        super.m_7373_(stack, level, tooltip, flag);
    }

    public int m_8105_(ItemStack stack) {
        return 25;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.NONE;
    }

    public void m_5929_(Level level, LivingEntity user, ItemStack stack, int count) {
        if (user instanceof Player) {
            Player player = (Player)user;
            if (count % 4 == 0) {
                player.m_21011_(player.m_7655_(), true);
            }
        }
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity user) {
        if (!level.f_46443_) {
            Player player;
            CompoundTag nbt = user.getPersistentData();
            int doses = nbt.m_128451_(NBT_DOSE_COUNT);
            nbt.m_128405_(NBT_DOSE_COUNT, ++doses);
            nbt.m_128405_(NBT_ACTIVE_TIME, 900);
            user.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 900, 3, false, false));
            user.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 900, 1, false, false));
            if (doses >= 3) {
                user.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 600, 0));
                if (user instanceof Player) {
                    player = (Player)user;
                    player.m_213846_((Component)Component.m_237115_((String)"message.skydrop.adrenaline.overdose").m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.BOLD));
                }
            }
            level.m_6263_(null, user.m_20185_(), user.m_20186_(), user.m_20189_(), SoundEvents.f_11772_, SoundSource.PLAYERS, 1.5f, 1.4f);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123750_, user.m_20185_(), user.m_20186_() + 1.2, user.m_20189_(), 5, 0.2, 0.2, 0.2, 0.1);
            }
            if (user instanceof Player) {
                player = (Player)user;
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
            }
        }
        return stack;
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        CompoundTag nbt;
        if (event.side.isServer() && event.phase == TickEvent.Phase.END && (nbt = (player = event.player).getPersistentData()).m_128441_(NBT_ACTIVE_TIME)) {
            int activeTicks = nbt.m_128451_(NBT_ACTIVE_TIME);
            if (activeTicks > 0) {
                nbt.m_128405_(NBT_ACTIVE_TIME, activeTicks - 1);
            } else {
                int doses = nbt.m_128451_(NBT_DOSE_COUNT);
                if (doses > 0) {
                    AdrenalineItem.applyProgressiveDebuffs(player, doses);
                    nbt.m_128473_(NBT_DOSE_COUNT);
                    nbt.m_128473_(NBT_ACTIVE_TIME);
                }
            }
        }
    }

    private static void applyProgressiveDebuffs(Player player, int doses) {
        int duration = 600 + doses * 300;
        if (doses == 1) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, duration, 1));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, duration, 0));
        } else if (doses == 2) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, duration, 2));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, duration, 1));
        } else {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, duration, 4));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 400, 1));
            player.m_213846_((Component)Component.m_237115_((String)"message.skydrop.adrenaline.lethal").m_130940_(ChatFormatting.DARK_RED));
        }
        player.m_213846_((Component)Component.m_237115_((String)"message.skydrop.adrenaline.crash").m_130940_(ChatFormatting.GRAY));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
    }
}

