/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.skydrop.item;

import com.j2k.skydrop.entity.SkyDropEntity;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DropCompassItem
extends Item {
    private static final Map<Level, CachedDropData> dropCache = new HashMap<Level, CachedDropData>();

    public DropCompassItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (!pLevel.f_46443_) {
            CachedDropData data = DropCompassItem.getCachedDropData(pLevel, pPlayer.m_20182_());
            if (data != null && data.nearestDropPos != null) {
                BlockPos target = data.nearestDropPos;
                double distance = pPlayer.m_20182_().m_82554_(Vec3.m_82512_((Vec3i)target));
                MutableComponent coords = Component.m_237113_((String)String.format("[%d, %d, %d] (%.0fm)", target.m_123341_(), target.m_123342_(), target.m_123343_(), distance)).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.AQUA).m_131136_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/trigger skydrop_waypoint set " + target.m_123341_() + " " + target.m_123343_())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"\u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u0434\u043b\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043f\u0443\u0442\u0435\u0432\u043e\u0439 \u0442\u043e\u0447\u043a\u0438"))));
                String dropsInfo = data.dropCount > 1 ? String.format(" \u00a77(+%d \u0434\u0440\u0443\u0433\u0438\u0445)", data.dropCount - 1) : "";
                pPlayer.m_213846_((Component)Component.m_237113_((String)"\u00a7a[\u041a\u043e\u043c\u043f\u0430\u0441] \u00a7f\u0421\u0438\u0433\u043d\u0430\u043b \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d: ").m_7220_((Component)coords).m_7220_((Component)Component.m_237113_((String)dropsInfo)));
            } else {
                pPlayer.m_213846_((Component)Component.m_237113_((String)"\u00a7c[\u041a\u043e\u043c\u043f\u0430\u0441] \u00a7f\u0421\u0438\u0433\u043d\u0430\u043b \u043f\u043e\u0442\u0435\u0440\u044f\u043d. \u0414\u0440\u043e\u043f\u043e\u0432 \u043d\u0435\u0442."));
            }
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    private static CachedDropData getCachedDropData(Level level, Vec3 center) {
        long currentTime = level.m_46467_();
        CachedDropData cached = dropCache.get(level);
        if (cached != null && !cached.isExpired(currentTime)) {
            return cached;
        }
        BlockPos nearestPos = DropCompassItem.findNearestDrop(level, center);
        int dropCount = DropCompassItem.countDropsInRange(level, center, 3000.0);
        CachedDropData newData = new CachedDropData(nearestPos, currentTime, dropCount);
        dropCache.put(level, newData);
        return newData;
    }

    public static BlockPos findNearestDrop(Level level, Vec3 center) {
        if (level == null) {
            return null;
        }
        AABB searchArea = new AABB(center.f_82479_ - 3000.0, -64.0, center.f_82481_ - 3000.0, center.f_82479_ + 3000.0, 320.0, center.f_82481_ + 3000.0);
        List drops = level.m_45976_(SkyDropEntity.class, searchArea);
        return drops.stream().min(Comparator.comparingDouble(e -> e.m_20182_().m_82557_(center))).map(Entity::m_20183_).orElse(null);
    }

    private static int countDropsInRange(Level level, Vec3 center, double range) {
        if (level == null) {
            return 0;
        }
        AABB searchArea = new AABB(center.f_82479_ - range, -64.0, center.f_82481_ - range, center.f_82479_ + range, 320.0, center.f_82481_ + range);
        return level.m_45976_(SkyDropEntity.class, searchArea).size();
    }

    public static float getAngle(Level level, LivingEntity entity, ItemStack stack) {
        if (level == null || entity == null) {
            return 0.0f;
        }
        Vec3 center = entity.m_20182_();
        CachedDropData data = DropCompassItem.getCachedDropData(level, center);
        if (data == null || data.nearestDropPos == null) {
            return (float)((double)(level.m_46467_() % 360L) / 360.0);
        }
        BlockPos target = data.nearestDropPos;
        double angleToTarget = Math.atan2((double)target.m_123343_() - entity.m_20189_(), (double)target.m_123341_() - entity.m_20185_());
        double entityRotation = Math.toRadians(entity.m_146908_() % 360.0f);
        double finalAngle = angleToTarget - entityRotation - 1.5707963267948966;
        return Mth.m_14091_((float)((float)(finalAngle / (Math.PI * 2))), (float)1.0f);
    }

    public static void clearCache(Level level) {
        dropCache.remove(level);
    }

    private static class CachedDropData {
        BlockPos nearestDropPos;
        long lastUpdateTime;
        int dropCount;

        CachedDropData(BlockPos pos, long time, int count) {
            this.nearestDropPos = pos;
            this.lastUpdateTime = time;
            this.dropCount = count;
        }

        boolean isExpired(long currentTime) {
            return currentTime - this.lastUpdateTime > 40L;
        }
    }
}

