/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.skydrop.item;

import com.j2k.skydrop.entity.FlareEntity;
import com.j2k.skydrop.init.ModItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FlareGunItem
extends Item {
    private static final String NBT_LOADED = "skydrop.is_loaded";

    public FlareGunItem(Item.Properties pProperties) {
        super(pProperties.m_41503_(15));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.skydrop.flare_gun.tooltip").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        if (FlareGunItem.isLoaded(stack)) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.skydrop.flare_gun.loaded").m_130940_(ChatFormatting.GREEN));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.skydrop.flare_gun.empty").m_130940_(ChatFormatting.RED));
        }
    }

    public boolean m_5812_(ItemStack pStack) {
        return FlareGunItem.isLoaded(pStack);
    }

    public static boolean isLoaded(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128471_(NBT_LOADED);
    }

    public static void setLoaded(ItemStack stack, boolean loaded) {
        stack.m_41784_().m_128379_(NBT_LOADED, loaded);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack gunStack = pPlayer.m_21120_(pHand);
        if (!FlareGunItem.isLoaded(gunStack)) {
            ItemStack ammoStack = this.findAmmo(pPlayer);
            if (!ammoStack.m_41619_() || pPlayer.m_150110_().f_35937_) {
                if (!pLevel.f_46443_) {
                    if (!pPlayer.m_150110_().f_35937_) {
                        ammoStack.m_41774_(1);
                    }
                    FlareGunItem.setLoaded(gunStack, true);
                    pLevel.m_6263_(null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_11677_, SoundSource.PLAYERS, 1.0f, 1.5f);
                }
                return InteractionResultHolder.m_19092_((Object)gunStack, (boolean)pLevel.m_5776_());
            }
            if (pLevel.f_46443_) {
                pPlayer.m_213846_((Component)Component.m_237115_((String)"message.skydrop.no_ammo"));
            }
            return InteractionResultHolder.m_19100_((Object)gunStack);
        }
        pLevel.m_6263_(null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_11928_, SoundSource.PLAYERS, 4.0f, 0.5f);
        if (!pLevel.f_46443_) {
            FlareEntity flare = new FlareEntity(pLevel, (LivingEntity)pPlayer);
            flare.m_37251_((Entity)pPlayer, pPlayer.m_146909_(), pPlayer.m_146908_(), 0.0f, 2.5f, 0.5f);
            pLevel.m_7967_((Entity)flare);
            this.spawnMuzzleFlash((ServerLevel)pLevel, pPlayer);
            FlareGunItem.setLoaded(gunStack, false);
            gunStack.m_41622_(1, (LivingEntity)pPlayer, player -> player.m_21190_(pHand));
        }
        pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        pPlayer.m_36335_().m_41524_((Item)this, 40);
        return InteractionResultHolder.m_19092_((Object)gunStack, (boolean)pLevel.m_5776_());
    }

    private ItemStack findAmmo(Player player) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (!stack.m_150930_((Item)ModItems.FLARE_CARTRIDGE.get())) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    private void spawnMuzzleFlash(ServerLevel level, Player player) {
        Vec3 lookVec = player.m_20154_();
        Vec3 startPos = player.m_146892_().m_82549_(lookVec.m_82490_(0.5));
        level.m_8767_((ParticleOptions)ParticleTypes.f_123744_, startPos.f_82479_, startPos.f_82480_, startPos.f_82481_, 15, 0.1, 0.1, 0.1, 0.1);
    }
}

