/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.skydrop.network;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class PacketSaveLoot {
    private final NonNullList<ItemStack> items;

    public PacketSaveLoot(NonNullList<ItemStack> items) {
        this.items = items;
    }

    public PacketSaveLoot(FriendlyByteBuf buf) {
        int size = buf.readInt();
        this.items = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
        for (int i = 0; i < size; ++i) {
            this.items.set(i, (Object)buf.m_130267_());
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.items.size());
        for (ItemStack item : this.items) {
            buf.m_130055_(item);
        }
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null && player.m_20310_(2)) {
                this.saveLootToFile(this.items, player);
            }
        });
        return true;
    }

    private void saveLootToFile(NonNullList<ItemStack> items, ServerPlayer player) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonObject root = new JsonObject();
        root.addProperty("type", "minecraft:chest");
        JsonArray pools = new JsonArray();
        JsonObject pool = new JsonObject();
        pool.addProperty("rolls", (Number)1);
        JsonArray entries = new JsonArray();
        for (ItemStack stack : items) {
            if (stack.m_41619_()) continue;
            JsonObject entry = new JsonObject();
            entry.addProperty("type", "minecraft:item");
            entry.addProperty("name", ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString());
            if (stack.m_41613_() > 1) {
                JsonArray functions = new JsonArray();
                JsonObject func = new JsonObject();
                func.addProperty("function", "minecraft:set_count");
                JsonObject count = new JsonObject();
                count.addProperty("min", (Number)stack.m_41613_());
                count.addProperty("max", (Number)stack.m_41613_());
                func.add("count", (JsonElement)count);
                functions.add((JsonElement)func);
                entry.add("functions", (JsonElement)functions);
            }
            entries.add((JsonElement)entry);
        }
        pool.add("entries", (JsonElement)entries);
        pools.add((JsonElement)pool);
        root.add("pools", (JsonElement)pools);
        File folder = FMLPaths.CONFIGDIR.get().resolve("skydrop").toFile();
        if (!folder.exists()) {
            folder.mkdirs();
        }
        File file = new File(folder, "custom_loot.json");
        try (FileWriter writer = new FileWriter(file);){
            gson.toJson((JsonElement)root, (Appendable)writer);
            player.m_213846_((Component)Component.m_237115_((String)"skydrop.network.save_success"));
        }
        catch (IOException e) {
            player.m_213846_((Component)Component.m_237110_((String)"skydrop.network.save_error", (Object[])new Object[]{e.getMessage()}));
            e.printStackTrace();
        }
    }
}

