/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.skydrop.network;

import com.j2k.skydrop.config.LootConfig;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class PacketSyncLootConfig {
    private byte[] compressedData;

    public PacketSyncLootConfig(List<LootConfig.LootEntry> entries) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             GZIPOutputStream gzos = new GZIPOutputStream(bos);
             DataOutputStream dos = new DataOutputStream(gzos);){
            dos.writeInt(entries.size());
            for (LootConfig.LootEntry e : entries) {
                dos.writeUTF(ForgeRegistries.ITEMS.getKey((Object)e.item).toString());
                boolean hasNbt = e.stack.m_41782_();
                dos.writeBoolean(hasNbt);
                if (hasNbt) {
                    dos.writeUTF(e.stack.m_41783_().toString());
                }
                dos.writeInt(e.weight);
                dos.writeUTF(e.rarity);
                dos.writeBoolean(e.enabled);
                dos.writeInt(e.minCount);
                dos.writeInt(e.maxCount);
            }
            gzos.finish();
            this.compressedData = bos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.compressedData = new byte[0];
        }
    }

    public PacketSyncLootConfig(FriendlyByteBuf buf) {
        this.compressedData = buf.m_130052_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130087_(this.compressedData);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            if (this.compressedData == null || this.compressedData.length == 0) {
                return;
            }
            ArrayList<LootConfig.LootEntry> entries = new ArrayList<LootConfig.LootEntry>();
            try (GZIPInputStream gzis = new GZIPInputStream(new ByteArrayInputStream(this.compressedData));
                 DataInputStream dis = new DataInputStream(gzis);){
                int size = dis.readInt();
                for (int i = 0; i < size; ++i) {
                    String id = dis.readUTF();
                    ItemStack stack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(id)));
                    if (dis.readBoolean()) {
                        stack.m_41751_(TagParser.m_129359_((String)dis.readUTF()));
                    }
                    LootConfig.LootEntry entry = new LootConfig.LootEntry(stack);
                    entry.weight = dis.readInt();
                    entry.rarity = dis.readUTF();
                    entry.enabled = dis.readBoolean();
                    entry.minCount = dis.readInt();
                    entry.maxCount = dis.readInt();
                    entries.add(entry);
                }
                LootConfig.getLootEntries().clear();
                LootConfig.getLootEntries().addAll(entries);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return true;
    }
}

