/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.skydrop.network;

import com.j2k.skydrop.SkyDrop;
import com.j2k.skydrop.config.LootConfig;
import com.j2k.skydrop.config.ModConfig;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class PacketUpdateLootSettings {
    private final int minItems;
    private final int maxItems;
    private final int lockTime;
    private final int destroyTime;
    private final boolean allowEmpty;
    private final boolean allowDuplicates;

    public PacketUpdateLootSettings(int minItems, int maxItems, int lockTime, int destroyTime, boolean allowEmpty, boolean allowDuplicates) {
        this.minItems = minItems;
        this.maxItems = maxItems;
        this.lockTime = lockTime;
        this.destroyTime = destroyTime;
        this.allowEmpty = allowEmpty;
        this.allowDuplicates = allowDuplicates;
    }

    public PacketUpdateLootSettings(FriendlyByteBuf buf) {
        this.minItems = buf.readInt();
        this.maxItems = buf.readInt();
        this.lockTime = buf.readInt();
        this.destroyTime = buf.readInt();
        this.allowEmpty = buf.readBoolean();
        this.allowDuplicates = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.minItems);
        buf.writeInt(this.maxItems);
        buf.writeInt(this.lockTime);
        buf.writeInt(this.destroyTime);
        buf.writeBoolean(this.allowEmpty);
        buf.writeBoolean(this.allowDuplicates);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null && player.m_20310_(2)) {
                LootConfig.setMinItems(this.minItems);
                LootConfig.setMaxItems(this.maxItems);
                LootConfig.setLockTime(this.lockTime);
                LootConfig.setDestroyTime(this.destroyTime);
                LootConfig.setAllowEmpty(this.allowEmpty);
                LootConfig.setAllowDuplicates(this.allowDuplicates);
                LootConfig.save();
                ModConfig.SPEC.save();
                player.m_213846_((Component)Component.m_237115_((String)"skydrop.network.settings_saved"));
                SkyDrop.LOGGER.info("Loot settings updated by {}: min={}, max={}, lock={}, destroy={}", new Object[]{player.m_7755_().getString(), this.minItems, this.maxItems, this.lockTime, this.destroyTime});
            }
        });
        return true;
    }
}

