/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.skydrop.screen;

import com.j2k.skydrop.screen.LootEditorMenu;
import com.j2k.skydrop.screen.tabs.BrowserTab;
import com.j2k.skydrop.screen.tabs.EditorTab;
import com.j2k.skydrop.screen.tabs.ItemsTab;
import com.j2k.skydrop.screen.tabs.SettingsTab;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class LootEditorScreen
extends AbstractContainerScreen<LootEditorMenu> {
    private static final int GUI_WIDTH = 310;
    private static final int GUI_HEIGHT = 205;
    public static final int COLOR_BG = -301331958;
    public static final int COLOR_BORDER = -13816531;
    public static final int COLOR_ACCENT = -22016;
    public static final int COLOR_TEXT_DIM = -11184811;
    private final List<EditorTab> tabsList = new ArrayList<EditorTab>();
    private int activeTabIndex = 0;
    private final List<Button> tabButtons = new ArrayList<Button>();

    public LootEditorScreen(LootEditorMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.f_97726_ = 310;
        this.f_97727_ = 205;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
        this.setupTabs();
        this.setActiveTab(this.activeTabIndex);
    }

    private void setupTabs() {
        this.tabsList.clear();
        this.tabButtons.clear();
        this.tabsList.add(new ItemsTab(this));
        this.tabsList.add(new BrowserTab(this));
        this.tabsList.add(new SettingsTab(this));
        int totalTabs = this.tabsList.size();
        int btnW = this.f_97726_ / totalTabs;
        int btnH = 20;
        for (int i = 0; i < totalTabs; ++i) {
            int index = i;
            Button btn = Button.m_253074_((Component)this.tabsList.get(i).getTitle(), b -> this.setActiveTab(index)).m_252987_(this.f_97735_ + i * btnW, this.f_97736_ - btnH, btnW - 1, btnH).m_253136_();
            this.tabButtons.add(btn);
            this.m_142416_((GuiEventListener)btn);
        }
    }

    public void setActiveTab(int index) {
        this.activeTabIndex = index;
        this.m_169413_();
        for (Button b : this.tabButtons) {
            this.m_142416_((GuiEventListener)b);
            b.f_93623_ = this.tabButtons.indexOf(b) != this.activeTabIndex;
        }
        if (this.activeTabIndex < this.tabsList.size()) {
            this.tabsList.get(this.activeTabIndex).init(this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_);
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        graphics.m_280509_(this.f_97735_, this.f_97736_, this.f_97735_ + this.f_97726_, this.f_97736_ + this.f_97727_, -301331958);
        graphics.m_280637_(this.f_97735_ - 1, this.f_97736_ - 1, this.f_97726_ + 2, this.f_97727_ + 2, -13816531);
        int btnW = this.f_97726_ / this.tabsList.size();
        graphics.m_280509_(this.f_97735_ + this.activeTabIndex * btnW, this.f_97736_ - 2, this.f_97735_ + this.activeTabIndex * btnW + btnW - 1, this.f_97736_, -22016);
        graphics.m_280056_(this.f_96547_, "SkyDrop v2.0", this.f_97735_ + this.f_97726_ - 65, this.f_97736_ - 30, -11184811, false);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        if (this.activeTabIndex < this.tabsList.size()) {
            this.tabsList.get(this.activeTabIndex).render(graphics, mouseX, mouseY, partialTick);
        }
        this.m_280072_(graphics, mouseX, mouseY);
    }

    public <T extends GuiEventListener & Renderable> T addConfigWidget(T widget) {
        return (T)this.m_142416_(widget);
    }

    public void enableScissor(GuiGraphics graphics, int x, int y, int width, int height) {
        graphics.m_280588_(x, y, x + width, y + height);
    }

    public void disableScissor(GuiGraphics graphics) {
        graphics.m_280618_();
    }

    protected void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.tabsList.get(this.activeTabIndex).mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.tabsList.get(this.activeTabIndex).mouseScrolled(mouseX, mouseY, delta)) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.tabsList.get(this.activeTabIndex).keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }
}

