/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.skydrop.screen.tabs;

import com.j2k.skydrop.config.LootConfig;
import com.j2k.skydrop.screen.LootEditorScreen;
import com.j2k.skydrop.screen.tabs.EditorTab;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class BrowserTab
extends EditorTab {
    private final Map<String, List<Item>> modItemsMap = new TreeMap<String, List<Item>>();
    private final List<String> modList = new ArrayList<String>();
    private List<Item> viewItems = new ArrayList<Item>();
    private String activeMod = "minecraft";
    private final Set<Item> selection = new HashSet<Item>();
    private String currentTargetRarity = "common";
    private int modScroll = 0;
    private int gridScroll = 0;
    private EditBox searchBox;
    private Button addBtn;

    public BrowserTab(LootEditorScreen screen) {
        super(screen);
        this.loadRegistry();
    }

    private void loadRegistry() {
        if (!this.modItemsMap.isEmpty()) {
            return;
        }
        for (Item item : ForgeRegistries.ITEMS) {
            ResourceLocation rl;
            if (item == Items.f_41852_ || (rl = ForgeRegistries.ITEMS.getKey((Object)item)) == null) continue;
            this.modItemsMap.computeIfAbsent(rl.m_135827_(), k -> new ArrayList()).add(item);
        }
        this.modList.addAll(this.modItemsMap.keySet());
        this.modList.sort(String::compareToIgnoreCase);
    }

    @Override
    public Component getTitle() {
        return Component.m_237115_((String)"skydrop.gui.tab.browser");
    }

    @Override
    public void init(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        int gridX = x + 92;
        this.searchBox = this.addWidget(new EditBox(this.font, gridX, y + 6, width - 100, 14, (Component)Component.m_237119_()));
        this.searchBox.m_257771_((Component)Component.m_237115_((String)"skydrop.gui.search"));
        this.searchBox.m_94151_(s -> {
            this.gridScroll = 0;
            this.updateView();
        });
        this.addWidget(CycleButton.m_168894_(s -> Component.m_237115_((String)("skydrop.rarity." + s)).m_130938_(st -> st.m_178520_(this.getRarityColor((String)s)))).m_168961_((Object[])new String[]{"common", "rare", "epic", "legendary"}).m_168948_((Object)this.currentTargetRarity).m_168936_(gridX, y + 22, 90, 16, (Component)Component.m_237119_(), (b, v) -> {
            this.currentTargetRarity = v;
        }));
        this.addBtn = this.addWidget(Button.m_253074_((Component)Component.m_237115_((String)"skydrop.gui.browser.add"), b -> this.processAdd()).m_252987_(gridX + 92, y + 22, 75, 16).m_253136_());
        this.updateView();
    }

    private void updateView() {
        String query = this.searchBox.m_94155_().toLowerCase();
        this.viewItems = this.modItemsMap.getOrDefault(this.activeMod, Collections.emptyList()).stream().filter(i -> i.m_41466_().getString().toLowerCase().contains(query)).toList();
    }

    @Override
    public void render(GuiGraphics g, int mx, int my, float pt) {
        this.drawPanel(g, this.x + 5, this.y + 6, 82, this.height - 12, "Mods");
        this.screen.enableScissor(g, this.x + 5, this.y + 6, 82, this.height - 12);
        for (int i = 0; i < this.modList.size(); ++i) {
            int myy = this.y + 10 + (i - this.modScroll) * 12;
            if (myy < this.y + 6 || myy > this.y + this.height - 12) continue;
            boolean isSel = this.modList.get(i).equals(this.activeMod);
            int color = isSel ? -22016 : (mx > this.x + 5 && mx < this.x + 87 && my > myy && my < myy + 12 ? 0xFFFFFF : 0x666666);
            g.m_280056_(this.font, this.font.m_92834_(this.modList.get(i), 72), this.x + 8, myy + 1, color, false);
        }
        this.screen.disableScissor(g);
        int gx = this.x + 92;
        int gy = this.y + 42;
        int gw = this.width - 100;
        int gh = this.height - 52;
        this.drawPanel(g, gx, gy, gw, gh, null);
        int cols = gw / 18;
        this.screen.enableScissor(g, gx, gy, gw, gh);
        for (int i = 0; i < this.viewItems.size(); ++i) {
            int col = i % cols;
            int row = i / cols;
            int ix = gx + 3 + col * 18;
            int iy = gy + 3 + (row - this.gridScroll) * 18;
            if (iy < gy - 18 || iy > gy + gh) continue;
            Item item = this.viewItems.get(i);
            if (this.selection.contains(item)) {
                g.m_280509_(ix - 1, iy - 1, ix + 17, iy + 17, 1728031232);
                g.m_280637_(ix - 1, iy - 1, 18, 18, 0xFFAA00);
            }
            g.m_280480_(new ItemStack((ItemLike)item), ix, iy);
        }
        this.screen.disableScissor(g);
    }

    private void processAdd() {
        if (this.selection.isEmpty()) {
            return;
        }
        for (Item item : this.selection) {
            LootConfig.LootEntry entry = new LootConfig.LootEntry(item);
            entry.rarity = this.currentTargetRarity;
            entry.weight = switch (this.currentTargetRarity) {
                case "legendary" -> 5;
                case "epic" -> 15;
                case "rare" -> 35;
                default -> 70;
            };
            LootConfig.addLootEntry(entry);
        }
        this.selection.clear();
        this.addBtn.m_93666_((Component)Component.m_237115_((String)"skydrop.gui.saved").m_130940_(ChatFormatting.GREEN));
    }

    @Override
    public boolean mouseClicked(double mx, double my, int b) {
        int c;
        int cols;
        int r;
        int idx;
        int idx2;
        if (mx > (double)(this.x + 5) && mx < (double)(this.x + 87) && (idx2 = this.modScroll + (int)((my - (double)(this.y + 10)) / 12.0)) >= 0 && idx2 < this.modList.size()) {
            this.activeMod = this.modList.get(idx2);
            this.gridScroll = 0;
            this.updateView();
            return true;
        }
        int gx = this.x + 92;
        int gy = this.y + 42;
        if (mx > (double)gx && my > (double)gy && mx < (double)(this.x + this.width - 8) && my < (double)(this.y + this.height - 10) && (idx = (r = (int)((my - (double)(gy + 3)) / 18.0) + this.gridScroll) * (cols = (this.width - 100) / 18) + (c = (int)((mx - (double)(gx + 3)) / 18.0))) >= 0 && idx < this.viewItems.size()) {
            Item item = this.viewItems.get(idx);
            if (Screen.m_96637_()) {
                if (!this.selection.add(item)) {
                    this.selection.remove(item);
                }
            } else {
                this.selection.clear();
                this.selection.add(item);
            }
            this.addBtn.m_93666_((Component)Component.m_237115_((String)"skydrop.gui.browser.add"));
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(double mx, double my, double d) {
        if (mx < (double)(this.x + 92)) {
            this.modScroll = Math.max(0, Math.min(this.modList.size() - 5, this.modScroll - (int)d));
        } else {
            this.gridScroll = Math.max(0, Math.min(this.viewItems.size() / 5, this.gridScroll - (int)d));
        }
        return true;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return this.searchBox.m_7933_(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean charTyped(char codePoint, int modifiers) {
        return this.searchBox.m_5534_(codePoint, modifiers);
    }
}

