/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.skydrop.screen.tabs;

import com.j2k.skydrop.screen.LootEditorScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;

public abstract class EditorTab {
    protected final LootEditorScreen screen;
    protected final Minecraft minecraft;
    protected final Font font;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    public static final int CLR_BG = -586478837;
    public static final int CLR_BORDER = -13816531;
    public static final int CLR_ACCENT = -22016;

    public EditorTab(LootEditorScreen screen) {
        this.screen = screen;
        this.minecraft = Minecraft.m_91087_();
        this.font = this.minecraft.f_91062_;
    }

    public abstract Component getTitle();

    public abstract void init(int var1, int var2, int var3, int var4);

    public abstract void render(GuiGraphics var1, int var2, int var3, float var4);

    protected <T extends GuiEventListener & Renderable> T addWidget(T widget) {
        return this.screen.addConfigWidget(widget);
    }

    protected void drawPanel(GuiGraphics g, int x, int y, int w, int h, String title) {
        g.m_280509_(x, y, x + w, y + h, -586478837);
        g.m_280637_(x, y, w, h, -13816531);
        if (title != null) {
            int tw = this.font.m_92895_(title);
            g.m_280509_(x, y - 10, x + tw + 8, y, -13816531);
            g.m_280056_(this.font, title, x + 4, y - 8, 0xAAAAAA, false);
        }
    }

    protected int getRarityColor(String rarity) {
        if (rarity == null) {
            return 0xFFFFFF;
        }
        return switch (rarity.toLowerCase()) {
            case "rare" -> 0x55FFFF;
            case "epic" -> 0xAA00FF;
            case "legendary" -> 0xFFAA00;
            default -> 0xFFFFFF;
        };
    }

    protected int getRarityRank(String rarity) {
        if (rarity == null) {
            return 0;
        }
        return switch (rarity.toLowerCase()) {
            case "legendary" -> 3;
            case "epic" -> 2;
            case "rare" -> 1;
            default -> 0;
        };
    }

    public boolean mouseClicked(double mx, double my, int b) {
        return false;
    }

    public boolean mouseScrolled(double mx, double my, double d) {
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    public boolean charTyped(char codePoint, int modifiers) {
        return false;
    }
}

