/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.skydrop.screen.tabs;

import com.j2k.skydrop.config.LootConfig;
import com.j2k.skydrop.screen.LootEditorScreen;
import com.j2k.skydrop.screen.tabs.EditorTab;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ItemsTab
extends EditorTab {
    private List<LootConfig.LootEntry> filteredEntries = new ArrayList<LootConfig.LootEntry>();
    private final Set<LootConfig.LootEntry> selectedEntries = new HashSet<LootConfig.LootEntry>();
    private int lastClickedIndex = -1;
    private EditBox searchBox;
    private EditBox weightBox;
    private EditBox minBox;
    private EditBox maxBox;
    private Button enableBtn;
    private Button saveBtn;
    private CycleButton<String> categoryFilter;
    private int scrollOffset = 0;
    private final int rowHeight = 20;
    private int listX;
    private int listY;
    private int listW;
    private int listH;
    private boolean isUpdating = false;

    public ItemsTab(LootEditorScreen screen) {
        super(screen);
    }

    @Override
    public Component getTitle() {
        return Component.m_237115_((String)"skydrop.gui.tab.items");
    }

    @Override
    public void init(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.listX = x + 6;
        this.listY = y + 42;
        this.listW = 165;
        this.listH = height - 48;
        int rX = this.listX + this.listW + 8;
        int rW = width - this.listW - 22;
        this.categoryFilter = this.addWidget(CycleButton.m_168894_(s -> {
            int color = this.getRarityColor((String)s);
            return Component.m_237115_((String)("skydrop.rarity." + s)).m_130938_(st -> st.m_178520_(color));
        }).m_168961_((Object[])new String[]{"all", "common", "rare", "epic", "legendary"}).m_168936_(this.listX, y + 4, this.listW, 16, (Component)Component.m_237119_(), (b, v) -> this.refresh()));
        this.searchBox = this.addWidget(new EditBox(this.font, this.listX, y + 24, this.listW, 14, (Component)Component.m_237119_()));
        this.searchBox.m_257771_((Component)Component.m_237115_((String)"skydrop.gui.search"));
        this.searchBox.m_94151_(s -> this.refresh());
        int currY = y + 16;
        this.weightBox = this.addWidget(new EditBox(this.font, rX, currY, rW, 14, (Component)Component.m_237119_()));
        this.weightBox.m_94151_(s -> this.applyValues());
        this.minBox = this.addWidget(new EditBox(this.font, rX, currY += 30, rW / 2 - 2, 14, (Component)Component.m_237119_()));
        this.maxBox = this.addWidget(new EditBox(this.font, rX + rW / 2 + 2, currY, rW / 2 - 2, 14, (Component)Component.m_237119_()));
        this.minBox.m_94151_(s -> this.applyValues());
        this.maxBox.m_94151_(s -> this.applyValues());
        this.addWidget(Button.m_253074_((Component)Component.m_237115_((String)"skydrop.gui.randomize"), b -> this.randomize()).m_252987_(rX, currY += 22, rW, 16).m_253136_());
        this.enableBtn = this.addWidget(Button.m_253074_((Component)Component.m_237119_(), b -> this.toggleStatus()).m_252987_(rX, currY += 18, rW, 16).m_253136_());
        this.addWidget(Button.m_253074_((Component)Component.m_237115_((String)"skydrop.gui.delete"), b -> this.delete()).m_252987_(rX, currY += 18, rW, 16).m_253136_());
        this.addWidget(Button.m_253074_((Component)Component.m_237115_((String)"skydrop.gui.copy_hand"), b -> this.copyFromHand()).m_252987_(rX, currY += 18, rW, 16).m_253136_());
        this.saveBtn = this.addWidget(Button.m_253074_((Component)Component.m_237115_((String)"skydrop.gui.save"), b -> {
            LootConfig.save();
            this.saveBtn.m_93666_((Component)Component.m_237115_((String)"skydrop.gui.saved").m_130940_(ChatFormatting.GREEN));
        }).m_252987_(rX, y + height - 20, rW, 16).m_253136_());
        this.refresh();
    }

    private void refresh() {
        this.filteredEntries.clear();
        String q = this.searchBox.m_94155_().toLowerCase();
        String cat = (String)this.categoryFilter.m_168883_();
        for (LootConfig.LootEntry e : LootConfig.getLootEntries()) {
            if (!cat.equals("all") && !e.rarity.equalsIgnoreCase(cat) || !q.isEmpty() && !e.item.m_41466_().getString().toLowerCase().contains(q)) continue;
            this.filteredEntries.add(e);
        }
        this.filteredEntries.sort(Comparator.comparingInt(a -> this.getRarityRank(a.rarity)));
        this.scrollOffset = 0;
    }

    @Override
    public void render(GuiGraphics g, int mx, int my, float pt) {
        this.drawPanel(g, this.listX, this.listY, this.listW, this.listH, null);
        int rX = this.listX + this.listW + 8;
        g.m_280614_(this.font, (Component)Component.m_237115_((String)"skydrop.gui.weight"), rX, this.y + 6, 0x888888, false);
        String countTitle = Component.m_237115_((String)"skydrop.gui.min").getString() + "/" + Component.m_237115_((String)"skydrop.gui.max").getString();
        g.m_280056_(this.font, countTitle, rX, this.y + 36, 0x888888, false);
        int totalW = this.filteredEntries.stream().filter(e -> e.enabled).mapToInt(e -> e.weight).sum();
        this.screen.enableScissor(g, this.listX, this.listY, this.listW, this.listH);
        for (int i = 0; i < this.filteredEntries.size(); ++i) {
            int ry = this.listY + (i - this.scrollOffset) * 20;
            if (ry < this.listY - 20 || ry > this.listY + this.listH) continue;
            LootConfig.LootEntry e2 = this.filteredEntries.get(i);
            boolean sel = this.selectedEntries.contains(e2);
            if (sel) {
                g.m_280509_(this.listX + 1, ry, this.listX + this.listW - 1, ry + 20, 872393216);
            }
            g.m_280480_(new ItemStack((ItemLike)e2.item), this.listX + 2, ry + 2);
            String name = e2.item.m_41466_().getString();
            g.m_280056_(this.font, this.font.m_92834_(name, 80), this.listX + 22, ry + 6, this.getRarityColor(e2.rarity), false);
            if (!e2.enabled || totalW <= 0) continue;
            String pct = String.format("%.1f%%", Float.valueOf((float)e2.weight / (float)totalW * 100.0f));
            g.m_280056_(this.font, pct, this.listX + this.listW - this.font.m_92895_(pct) - 4, ry + 6, 0x444444, false);
        }
        this.screen.disableScissor(g);
        this.updateInspector();
    }

    private void updateInspector() {
        if (this.selectedEntries.isEmpty() || this.isUpdating) {
            return;
        }
        this.isUpdating = true;
        LootConfig.LootEntry e = this.selectedEntries.iterator().next();
        if (!this.weightBox.m_93696_()) {
            this.weightBox.m_94144_(String.valueOf(e.weight));
        }
        if (!this.minBox.m_93696_()) {
            this.minBox.m_94144_(String.valueOf(e.minCount));
        }
        if (!this.maxBox.m_93696_()) {
            this.maxBox.m_94144_(String.valueOf(e.maxCount));
        }
        this.enableBtn.m_93666_((Component)Component.m_237115_((String)(e.enabled ? "skydrop.gui.enabled" : "skydrop.gui.disabled")).m_130940_(e.enabled ? ChatFormatting.GREEN : ChatFormatting.RED));
        this.isUpdating = false;
    }

    private void applyValues() {
        if (this.selectedEntries.isEmpty() || this.isUpdating) {
            return;
        }
        try {
            String wStr = this.weightBox.m_94155_().replaceAll("[^0-9]", "");
            String minStr = this.minBox.m_94155_().replaceAll("[^0-9]", "");
            String maxStr = this.maxBox.m_94155_().replaceAll("[^0-9]", "");
            if (wStr.isEmpty() || minStr.isEmpty() || maxStr.isEmpty()) {
                return;
            }
            int w = Integer.parseInt(wStr);
            int min = Integer.parseInt(minStr);
            int max = Integer.parseInt(maxStr);
            for (LootConfig.LootEntry e : this.selectedEntries) {
                e.weight = w;
                e.minCount = min;
                e.maxCount = Math.max(min, max);
                LootConfig.updateLootEntry(e.item, e);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void randomize() {
        if (this.selectedEntries.isEmpty()) {
            return;
        }
        this.isUpdating = true;
        Random r = new Random();
        for (LootConfig.LootEntry e : this.selectedEntries) {
            e.weight = r.nextInt(100) + 1;
            int maxS = e.item.m_7968_().m_41741_();
            if (maxS <= 1) {
                e.minCount = 1;
                e.maxCount = 1;
            } else {
                int bound = Math.max(2, maxS / 2);
                e.minCount = r.nextInt(bound) + 1;
                int remaining = maxS - e.minCount;
                e.maxCount = e.minCount + (remaining > 0 ? r.nextInt(remaining + 1) : 0);
            }
            LootConfig.updateLootEntry(e.item, e);
        }
        LootConfig.LootEntry first = this.selectedEntries.iterator().next();
        this.weightBox.m_94144_(String.valueOf(first.weight));
        this.minBox.m_94144_(String.valueOf(first.minCount));
        this.maxBox.m_94144_(String.valueOf(first.maxCount));
        this.isUpdating = false;
    }

    private void toggleStatus() {
        for (LootConfig.LootEntry e : this.selectedEntries) {
            e.enabled = !e.enabled;
            LootConfig.updateLootEntry(e.item, e);
        }
    }

    private void delete() {
        for (LootConfig.LootEntry e : this.selectedEntries) {
            LootConfig.removeLootEntry(e.item);
        }
        this.selectedEntries.clear();
        this.refresh();
    }

    private void copyFromHand() {
        ItemStack s = this.minecraft.f_91074_.m_21205_();
        if (s.m_41619_()) {
            return;
        }
        LootConfig.addLootEntry(new LootConfig.LootEntry(s.m_41777_()));
        this.refresh();
    }

    @Override
    public boolean mouseClicked(double mx, double my, int b) {
        int idx;
        if (mx > (double)this.listX && mx < (double)(this.listX + this.listW) && my > (double)this.listY && my < (double)(this.listY + this.listH) && (idx = this.scrollOffset + (int)((my - (double)this.listY) / 20.0)) >= 0 && idx < this.filteredEntries.size()) {
            LootConfig.LootEntry e = this.filteredEntries.get(idx);
            if (Screen.m_96638_() && this.lastClickedIndex != -1) {
                int start = Math.min(this.lastClickedIndex, idx);
                int end = Math.max(this.lastClickedIndex, idx);
                this.selectedEntries.clear();
                for (int i = start; i <= end; ++i) {
                    this.selectedEntries.add(this.filteredEntries.get(i));
                }
            } else if (Screen.m_96637_()) {
                if (!this.selectedEntries.add(e)) {
                    this.selectedEntries.remove(e);
                }
            } else {
                this.selectedEntries.clear();
                this.selectedEntries.add(e);
            }
            this.lastClickedIndex = idx;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(double mx, double my, double d) {
        if (mx > (double)this.listX && mx < (double)(this.listX + this.listW)) {
            this.scrollOffset = Math.max(0, Math.min(this.filteredEntries.size() - this.listH / 20, this.scrollOffset - (int)d));
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(int k, int s, int m) {
        if (this.searchBox.m_7933_(k, s, m)) {
            return true;
        }
        if (this.weightBox.m_7933_(k, s, m)) {
            return true;
        }
        if (this.minBox.m_7933_(k, s, m)) {
            return true;
        }
        if (this.maxBox.m_7933_(k, s, m)) {
            return true;
        }
        return super.keyPressed(k, s, m);
    }

    @Override
    public boolean charTyped(char c, int m) {
        if (this.searchBox.m_5534_(c, m)) {
            return true;
        }
        if (this.weightBox.m_5534_(c, m)) {
            return true;
        }
        if (this.minBox.m_5534_(c, m)) {
            return true;
        }
        if (this.maxBox.m_5534_(c, m)) {
            return true;
        }
        return super.charTyped(c, m);
    }
}

