/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.skydrop.screen.tabs;

import com.j2k.skydrop.config.LootConfig;
import com.j2k.skydrop.config.ModConfig;
import com.j2k.skydrop.init.ModBlocks;
import com.j2k.skydrop.screen.LootEditorScreen;
import com.j2k.skydrop.screen.tabs.EditorTab;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class SettingsTab
extends EditorTab {
    private EditBox lockTime;
    private EditBox lifeTime;
    private EditBox dropHeight;
    private EditBox interval;
    private EditBox radius;
    private EditBox rB;
    private EditBox gB;
    private EditBox bB;
    private EditBox newConfigName;
    private CycleButton<Boolean> autoSpawnToggle;
    private CycleButton<Boolean> beamToggle;
    private CycleButton<Boolean> notifyToggle;
    private float rotation = 0.0f;

    public SettingsTab(LootEditorScreen screen) {
        super(screen);
    }

    @Override
    public Component getTitle() {
        return Component.m_237115_((String)"skydrop.gui.tab.settings");
    }

    @Override
    public void init(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        int lx = x + 10;
        int rx = x + 155;
        this.addWidget(CycleButton.m_168894_(Component::m_237113_).m_232502_(LootConfig.getAvailableConfigs()).m_168948_((Object)LootConfig.getCurrentConfigName()).m_168936_(lx, y + 10, 120, 16, (Component)Component.m_237119_(), (b, v) -> {
            LootConfig.load(v);
            this.screen.setActiveTab(2);
        }));
        this.newConfigName = this.addWidget(new EditBox(this.font, lx, y + 28, 90, 14, (Component)Component.m_237119_()));
        this.newConfigName.m_257771_((Component)Component.m_237115_((String)"skydrop.gui.settings.new_config_hint"));
        this.addWidget(Button.m_253074_((Component)Component.m_237113_((String)"+"), b -> {
            String name = this.newConfigName.m_94155_();
            if (!name.isEmpty()) {
                LootConfig.createNewConfig(name);
                this.screen.setActiveTab(2);
            }
        }).m_252987_(lx + 92, y + 28, 28, 14).m_253136_());
        int gameY = y + 55;
        this.lockTime = this.createF(lx + 85, gameY + 5, 35, String.valueOf(LootConfig.getLockTime()));
        this.lifeTime = this.createF(lx + 85, gameY + 21, 35, String.valueOf(LootConfig.getDestroyTime()));
        int sy = y + 100;
        this.dropHeight = this.createF(lx + 85, sy + 12, 35, String.valueOf(ModConfig.DROP_HEIGHT.get()));
        this.interval = this.createF(lx + 85, sy + 28, 35, String.valueOf((Integer)ModConfig.DROP_INTERVAL.get() / 1200));
        this.radius = this.createF(lx + 85, sy + 44, 35, String.valueOf(ModConfig.DROP_RADIUS.get()));
        this.autoSpawnToggle = this.addWidget(CycleButton.m_168916_((boolean)((Boolean)ModConfig.SHOULD_SPAWN_AUTOMATICALLY.get())).m_168936_(lx, sy + 62, 130, 16, (Component)Component.m_237115_((String)"skydrop.gui.settings.autospawn"), (b, v) -> {}));
        int boxY = y + 25;
        this.rB = this.createF(rx + 60, boxY, 20, String.valueOf(LootConfig.getBeamColorR()));
        this.gB = this.createF(rx + 82, boxY, 20, String.valueOf(LootConfig.getBeamColorG()));
        this.bB = this.createF(rx + 104, boxY, 20, String.valueOf(LootConfig.getBeamColorB()));
        this.beamToggle = this.addWidget(CycleButton.m_168916_((boolean)LootConfig.isBeamEnabled()).m_168936_(rx + 5, y + 52, 120, 16, (Component)Component.m_237115_((String)"skydrop.config.enable_beam"), (b, v) -> {}));
        this.notifyToggle = this.addWidget(CycleButton.m_168916_((boolean)LootConfig.shouldNotifySpawn()).m_168936_(rx + 5, y + 70, 120, 16, (Component)Component.m_237115_((String)"skydrop.gui.settings.notify"), (b, v) -> {}));
        this.addWidget(Button.m_253074_((Component)Component.m_237115_((String)"skydrop.gui.save"), b -> this.save()).m_252987_(x + width - 70, y + height - 20, 60, 16).m_253136_());
    }

    private EditBox createF(int x, int y, int w, String v) {
        EditBox e = new EditBox(this.font, x, y, w, 12, (Component)Component.m_237119_());
        e.m_94144_(v);
        e.m_94153_(s -> s.matches("^[0-9]*$"));
        return this.addWidget(e);
    }

    @Override
    public void render(GuiGraphics g, int mx, int my, float pt) {
        int lx = this.x + 10;
        int rx = this.x + 155;
        g.m_280614_(this.font, (Component)Component.m_237115_((String)"skydrop.gui.settings.gameplay"), lx, this.y + 48, 0x55FFFF, false);
        g.m_280614_(this.font, (Component)Component.m_237115_((String)"skydrop.gui.settings.lock"), lx + 5, this.y + 61, 0xAAAAAA, false);
        g.m_280614_(this.font, (Component)Component.m_237115_((String)"skydrop.gui.settings.life"), lx + 5, this.y + 77, 0xAAAAAA, false);
        g.m_280614_(this.font, (Component)Component.m_237115_((String)"skydrop.gui.settings.spawn"), lx, this.y + 100, 0x55FF55, false);
        g.m_280614_(this.font, (Component)Component.m_237115_((String)"skydrop.gui.settings.height"), lx + 5, this.y + 113, 0xAAAAAA, false);
        g.m_280614_(this.font, (Component)Component.m_237115_((String)"skydrop.gui.settings.interval"), lx + 5, this.y + 129, 0xAAAAAA, false);
        g.m_280614_(this.font, (Component)Component.m_237115_((String)"skydrop.gui.settings.radius"), lx + 5, this.y + 145, 0xAAAAAA, false);
        g.m_280614_(this.font, (Component)Component.m_237115_((String)"skydrop.gui.settings.visual"), rx, this.y + 12, 0xFF55FF, false);
        g.m_280614_(this.font, (Component)Component.m_237115_((String)"skydrop.gui.settings.beam"), rx + 5, this.y + 27, 0xAAAAAA, false);
        try {
            int r = Integer.parseInt(this.rB.m_94155_());
            int ge = Integer.parseInt(this.gB.m_94155_());
            int b = Integer.parseInt(this.bB.m_94155_());
            int c = 0xFF000000 | (r & 0xFF) << 16 | (ge & 0xFF) << 8 | b & 0xFF;
            g.m_280509_(rx + 5, this.y + 40, rx + 125, this.y + 48, c);
            g.m_280637_(rx + 5, this.y + 40, 120, 8, -1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.drawPanel(g, rx + 5, this.y + 90, 120, 65, Component.m_237115_((String)"skydrop.gui.settings.preview").getString());
        this.rotation += pt * 1.2f;
        this.renderModel(g, rx + 65, this.y + 138, this.rotation);
    }

    private void renderModel(GuiGraphics g, int x, int y, float rot) {
        ItemStack s = new ItemStack((ItemLike)ModBlocks.SKY_DROP_CRATE.get());
        PoseStack ps = g.m_280168_();
        ps.m_85836_();
        ps.m_252880_((float)x, (float)y, 100.0f);
        ps.m_85841_(32.0f, -32.0f, 32.0f);
        ps.m_252781_(Axis.f_252529_.m_252977_(20.0f));
        ps.m_252781_(Axis.f_252436_.m_252977_(rot));
        Lighting.m_84931_();
        this.minecraft.m_91291_().m_269128_(s, ItemDisplayContext.FIXED, 0xF000F0, 0, ps, (MultiBufferSource)g.m_280091_(), (Level)this.minecraft.f_91073_, 0);
        ps.m_85849_();
    }

    private void save() {
        try {
            LootConfig.setLockTime(Math.max(1, Integer.parseInt(this.lockTime.m_94155_().isEmpty() ? "1" : this.lockTime.m_94155_())));
            LootConfig.setDestroyTime(Math.max(1, Integer.parseInt(this.lifeTime.m_94155_().isEmpty() ? "1" : this.lifeTime.m_94155_())));
            LootConfig.setEnableBeam((Boolean)this.beamToggle.m_168883_());
            LootConfig.setNotifySpawn((Boolean)this.notifyToggle.m_168883_());
            LootConfig.setBeamColorR(Math.min(255, Integer.parseInt(this.rB.m_94155_())));
            LootConfig.setBeamColorG(Math.min(255, Integer.parseInt(this.gB.m_94155_())));
            LootConfig.setBeamColorB(Math.min(255, Integer.parseInt(this.bB.m_94155_())));
            ModConfig.DROP_HEIGHT.set((Object)Integer.parseInt(this.dropHeight.m_94155_()));
            ModConfig.DROP_INTERVAL.set((Object)(Integer.parseInt(this.interval.m_94155_()) * 1200));
            ModConfig.DROP_RADIUS.set((Object)Integer.parseInt(this.radius.m_94155_()));
            ModConfig.SHOULD_SPAWN_AUTOMATICALLY.set((Object)((Boolean)this.autoSpawnToggle.m_168883_()));
            LootConfig.save();
            ModConfig.SPEC.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean keyPressed(int k, int s, int m) {
        if (this.newConfigName.m_7933_(k, s, m)) {
            return true;
        }
        if (this.lockTime.m_7933_(k, s, m)) {
            return true;
        }
        if (this.lifeTime.m_7933_(k, s, m)) {
            return true;
        }
        if (this.dropHeight.m_7933_(k, s, m)) {
            return true;
        }
        if (this.interval.m_7933_(k, s, m)) {
            return true;
        }
        if (this.radius.m_7933_(k, s, m)) {
            return true;
        }
        if (this.rB.m_7933_(k, s, m) || this.gB.m_7933_(k, s, m) || this.bB.m_7933_(k, s, m)) {
            return true;
        }
        return super.keyPressed(k, s, m);
    }

    @Override
    public boolean charTyped(char c, int m) {
        if (this.newConfigName.m_5534_(c, m)) {
            return true;
        }
        if (this.lockTime.m_5534_(c, m)) {
            return true;
        }
        if (this.lifeTime.m_5534_(c, m)) {
            return true;
        }
        if (this.dropHeight.m_5534_(c, m)) {
            return true;
        }
        if (this.interval.m_5534_(c, m)) {
            return true;
        }
        if (this.radius.m_5534_(c, m)) {
            return true;
        }
        if (this.rB.m_5534_(c, m) || this.gB.m_5534_(c, m) || this.bB.m_5534_(c, m)) {
            return true;
        }
        return super.charTyped(c, m);
    }
}

