/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.skydrop.util;

import java.util.List;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;

public class LuckSystem {
    private static final Set<Item> LEGENDARY_ITEMS = Set.of(Items.f_42418_, Items.f_42791_, Items.f_42437_, Items.f_42747_, Items.f_42741_, Items.f_42104_, Items.f_42686_, Items.f_42065_, Items.f_265918_);
    private static final Set<Item> EPIC_ITEMS = Set.of(Items.f_41959_, Items.f_42473_, Items.f_42713_, Items.f_42436_, Items.f_42419_);

    public static Component getCrateTitle(List<ItemStack> items) {
        String style = LuckSystem.getLuckStyle(items);
        return Component.m_237115_((String)("skydrop.rarity." + style + "_full"));
    }

    public static String getLuckStyle(List<ItemStack> items) {
        boolean isLegendary = false;
        boolean isEpic = false;
        boolean isRare = false;
        for (ItemStack stack : items) {
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            Rarity vanillaRarity = stack.m_41791_();
            if (LEGENDARY_ITEMS.contains(item)) {
                isLegendary = true;
            }
            if (EPIC_ITEMS.contains(item)) {
                isEpic = true;
            }
            if (vanillaRarity == Rarity.EPIC) {
                isLegendary = true;
            }
            if (vanillaRarity == Rarity.RARE) {
                isEpic = true;
            }
            if (vanillaRarity == Rarity.UNCOMMON) {
                isRare = true;
            }
            if (!stack.m_41793_()) continue;
            isRare = true;
            if (stack.m_41785_().size() <= 3) continue;
            isEpic = true;
        }
        if (isLegendary) {
            return "legendary";
        }
        if (isEpic) {
            return "epic";
        }
        if (isRare) {
            return "rare";
        }
        return "common";
    }
}

