/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.skydrop.util;

import com.j2k.skydrop.config.LootConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class MapIntegration {
    private static String getBiomeName(Level level, BlockPos pos) {
        ResourceLocation key = level.m_9598_().m_175515_(Registries.f_256952_).m_7981_((Object)((Biome)level.m_204166_(pos).m_203334_()));
        if (key != null) {
            String path = key.m_135815_();
            String[] words = path.split("_");
            StringBuilder sb = new StringBuilder();
            for (String w : words) {
                if (w.isEmpty()) continue;
                sb.append(Character.toUpperCase(w.charAt(0))).append(w.substring(1)).append(" ");
            }
            return sb.toString().trim();
        }
        return Component.m_237115_((String)"skydrop.message.unknown").getString();
    }

    public static Component createWaypointMessage(BlockPos pos, String label) {
        return MapIntegration.createWaypointMessage(pos, label, ChatFormatting.AQUA);
    }

    public static Component createWaypointMessage(BlockPos pos, String label, ChatFormatting color) {
        String coords = String.format("[%d, %d, %d]", pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        return Component.m_237113_((String)coords).m_6270_(Style.f_131099_.m_131140_(color).m_131136_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, MapIntegration.createWaypointCommand(pos, label))).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237110_((String)"skydrop.message.waypoint_tooltip", (Object[])new Object[]{label}))));
    }

    private static String createWaypointCommand(BlockPos pos, String label) {
        return String.format("/jm wpedit create %d %d %d %s", pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), label.replace(" ", "_"));
    }

    public static void announceDropSpawned(ServerPlayer player, BlockPos spawnPos) {
        if (!LootConfig.shouldNotifySpawn()) {
            return;
        }
        double distance = Math.sqrt(player.m_20275_((double)spawnPos.m_123341_(), (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_()));
        Component distComp = MapIntegration.getDistanceComponent(distance);
        String biome = MapIntegration.getBiomeName(player.m_9236_(), spawnPos);
        MutableComponent message = Component.m_237115_((String)"skydrop.message.prefix").m_7220_((Component)Component.m_237115_((String)"skydrop.message.spawned")).m_7220_(MapIntegration.createWaypointMessage(spawnPos, "SkyDrop_Spawn", ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_(distComp).m_7220_((Component)Component.m_237110_((String)"skydrop.message.biome", (Object[])new Object[]{biome}));
        player.m_213846_((Component)message);
    }

    public static void announceDropLanded(ServerPlayer player, BlockPos landPos, double driftDistance) {
        if (!LootConfig.shouldNotifySpawn()) {
            return;
        }
        double distance = Math.sqrt(player.m_20275_((double)landPos.m_123341_(), (double)landPos.m_123342_(), (double)landPos.m_123343_()));
        Component distComp = MapIntegration.getDistanceComponent(distance);
        MutableComponent driftComp = Component.m_237113_((String)String.format(" \u00a77[\u2194 %.0f\u043c]", driftDistance)).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY));
        String biome = MapIntegration.getBiomeName(player.m_9236_(), landPos);
        MutableComponent message = Component.m_237115_((String)"skydrop.message.prefix").m_7220_((Component)Component.m_237115_((String)"skydrop.message.landed")).m_7220_(MapIntegration.createWaypointMessage(landPos, "SkyDrop_Landed", ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_(distComp).m_7220_((Component)driftComp).m_7220_((Component)Component.m_237110_((String)"skydrop.message.location", (Object[])new Object[]{biome}));
        player.m_213846_((Component)message);
    }

    public static void announceDropToPlayer(ServerPlayer player, BlockPos pos) {
        if (!LootConfig.shouldNotifySpawn()) {
            return;
        }
        MutableComponent message = Component.m_237115_((String)"skydrop.message.prefix").m_7220_((Component)Component.m_237115_((String)"skydrop.message.found")).m_7220_(MapIntegration.createWaypointMessage(pos, "SkyDrop")).m_7220_((Component)Component.m_237115_((String)"skydrop.message.marker_hint"));
        player.m_213846_((Component)message);
    }

    public static void announceDropInRadius(ServerPlayer source, BlockPos pos, double radius) {
        if (!LootConfig.shouldNotifySpawn()) {
            return;
        }
        source.m_284548_().m_6907_().stream().filter(p -> p.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) <= radius * radius).forEach(p -> MapIntegration.announceDropToPlayer(p, pos));
    }

    private static Component getDistanceComponent(double distance) {
        String icon;
        ChatFormatting color;
        if (distance < 100.0) {
            color = ChatFormatting.GREEN;
            icon = "\u2713";
        } else if (distance < 500.0) {
            color = ChatFormatting.YELLOW;
            icon = "\u26a0";
        } else {
            color = ChatFormatting.RED;
            icon = "\u26a0";
        }
        return Component.m_237113_((String)String.format("[%s %.0f\u043c]", icon, distance)).m_130940_(color);
    }
}

