/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.skydrop.world;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class SkyDropStats
extends SavedData {
    private static final String DATA_NAME = "skydrop_stats";
    private final Map<UUID, Integer> playerCaptures = new HashMap<UUID, Integer>();
    private final Map<UUID, String> playerNames = new HashMap<UUID, String>();

    public static SkyDropStats get(ServerLevel level) {
        return (SkyDropStats)level.m_8895_().m_164861_(SkyDropStats::load, SkyDropStats::new, DATA_NAME);
    }

    public void addCapture(UUID playerUUID, String playerName) {
        this.playerCaptures.put(playerUUID, this.playerCaptures.getOrDefault(playerUUID, 0) + 1);
        this.playerNames.put(playerUUID, playerName);
        this.m_77762_();
    }

    public String getTopList() {
        if (this.playerCaptures.isEmpty()) {
            return Component.m_237115_((String)"skydrop.stats.empty").getString();
        }
        return this.playerCaptures.entrySet().stream().sorted((e1, e2) -> ((Integer)e2.getValue()).compareTo((Integer)e1.getValue())).limit(10L).map(entry -> {
            String name = this.playerNames.getOrDefault(entry.getKey(), "Unknown");
            return Component.m_237110_((String)"skydrop.stats.entry", (Object[])new Object[]{name, entry.getValue()}).getString();
        }).collect(Collectors.joining("\n"));
    }

    public static SkyDropStats load(CompoundTag tag) {
        SkyDropStats stats = new SkyDropStats();
        ListTag list = tag.m_128437_("captures", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag entry = list.m_128728_(i);
            UUID id = entry.m_128342_("uuid");
            int count = entry.m_128451_("count");
            String name = entry.m_128461_("name");
            stats.playerCaptures.put(id, count);
            stats.playerNames.put(id, name);
        }
        return stats;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag list = new ListTag();
        this.playerCaptures.forEach((uuid, count) -> {
            CompoundTag entry = new CompoundTag();
            entry.m_128362_("uuid", uuid);
            entry.m_128405_("count", count.intValue());
            entry.m_128359_("name", this.playerNames.getOrDefault(uuid, "Unknown"));
            list.add((Object)entry);
        });
        tag.m_128365_("captures", (Tag)list);
        return tag;
    }
}

