/*
 * Decompiled with CFR 0.152.
 */
package net.eman3600.hdemise.cardinal_components;

import net.eman3600.hdemise.init.ModAttributes;
import net.eman3600.hdemise.init.ModEntityComponents;
import net.eman3600.hdemise.networking.s2c.SoulEventPayload;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1656;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5131;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_8710;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.ClientTickingComponent;
import org.ladysnake.cca.api.v3.component.tick.ServerTickingComponent;

public class SoulComponent
implements AutoSyncedComponent,
ServerTickingComponent,
ClientTickingComponent {
    public static final int SOUL_PER_VESSEL = 80;
    public static final int SOUL_PER_XP = 10;
    public static final int SOUL_DECAY_TICKS = 10;
    public static final int SOUL_DECAY_AMOUNT = 1;
    public static final int BURN_SOUL_PER_TICK = 1;
    public static final int EXHAUSTION_THRESHOLD = 0;
    public static final int FOCUS_LENGTH = 20;
    public static final int FOCUS_DELAY = 8;
    public static final int FOCUS_RATE = 4;
    public static final float FOCUS_HP = 6.0f;
    public static final int VANISH_TICKS = 20;
    public static final int VANISH_DELAY = 5;
    public static final int REVEAL_TICKS = 8;
    public static final int VANISH_RATE = 2;
    public static final int WARNING_TICKS = 4;
    public static final int CURE_TICKS = 60;
    @Environment(value=EnvType.CLIENT)
    public static final int SUN_TICKS = 15;
    @Environment(value=EnvType.CLIENT)
    public int sunTicks;
    @Environment(value=EnvType.CLIENT)
    public static final int CURE_RENDER_TICKS = 60;
    @Environment(value=EnvType.CLIENT)
    public int cureRenderTicks;
    public static final class_2960 HP_ATTRIBUTE_ID = class_2960.method_60655((String)"hdemise", (String)"soul_hp");
    public static final class_2960 SPEED_ATTRIBUTE_ID = class_2960.method_60655((String)"hdemise", (String)"soul_speed");
    public static final class_2960 MAX_SOUL_ATTRIBUTE_ID = class_2960.method_60655((String)"hdemise", (String)"soul_max");
    private boolean demonForm = false;
    private boolean ghostMode = false;
    private int soul = 0;
    private int soulDecay = 0;
    private boolean isDirty = false;
    private boolean focusing = false;
    private int focusTime = 0;
    private boolean vanishing = false;
    private int vanishTime = 0;
    private boolean curing = false;
    private int cureTime = 0;
    private int warningTicks = 0;
    private final class_1657 player;

    public SoulComponent(class_1657 player) {
        this.player = player;
    }

    public void setForm(boolean demonForm) {
        this.demonForm = demonForm;
        if (demonForm) {
            this.resetSoul();
        } else {
            this.soul = 0;
            this.player.method_7344().method_7580(20);
            this.player.method_7344().method_7581(5.0f);
            this.setFocusing(false);
            this.setGhost(false);
            this.reloadAttributes();
        }
        this.markDirty();
    }

    public boolean isDemon() {
        return this.demonForm;
    }

    public boolean isGhost() {
        return this.ghostMode;
    }

    public int getSoul() {
        return this.soul;
    }

    public int getMaxSoul() {
        return 80 * Math.max(1, (int)this.player.method_45325(ModAttributes.MAX_SOUL));
    }

    public int getFocusRequirement() {
        return 80;
    }

    public boolean canFocus() {
        return (this.soul >= this.getFocusRequirement() && this.player.method_24828() || this.player.method_68878()) && this.isDemon() && !this.isGhost() && !this.vanishing && !this.curing;
    }

    public boolean canVanish() {
        return (this.soul > 0 || this.player.method_68878()) && this.isDemon() && !this.focusing && !this.curing;
    }

    public boolean canCure() {
        return this.isDemon() && !this.focusing && !this.vanishing;
    }

    public float getSoulVessels() {
        return (float)this.soul / 80.0f;
    }

    public void gainSoulFromXP(int xp) {
        this.addSoul(xp * 10);
    }

    public void addSoul(int gain) {
        this.setSoul(this.soul + gain);
    }

    public void setSoul(int soul) {
        this.soul = class_3532.method_15340((int)soul, (int)0, (int)this.getMaxSoul());
        this.markDirty();
    }

    public void warnSoul() {
        this.warningTicks = 4;
        this.markDirty();
    }

    public int getWarning() {
        return this.warningTicks;
    }

    public void setFocusing(boolean focusing) {
        this.focusing = focusing;
        this.focusTime = -8;
        this.markDirty();
    }

    public void setVanishing(boolean vanishing) {
        this.vanishing = vanishing;
        int n = this.vanishTime = vanishing && !this.isGhost() ? -5 : 0;
        if (this.player.method_5854() != null) {
            this.player.method_5848();
        }
        this.markDirty();
    }

    public void setCuring(boolean curing, int cureTime) {
        this.curing = curing;
        if (curing) {
            this.cureTime = cureTime;
        }
        if (this.player.method_5854() != null) {
            this.player.method_5848();
        }
        this.markDirty();
    }

    public void interruptVanish() {
        this.vanishing = false;
        this.vanishTime = 0;
        this.setSoul(this.getSoul() / 2);
        this.warnSoul();
        this.markDirty();
    }

    public void interruptCure() {
        this.curing = false;
        this.cureTime = 0;
        this.setSoul(0);
        this.warnSoul();
        this.markDirty();
    }

    public boolean isVanishing() {
        return this.vanishing;
    }

    public void setGhost(boolean ghost) {
        this.ghostMode = ghost;
        if (this.player.method_5854() != null) {
            this.player.method_5848();
        }
        this.soulDecay = 10;
        this.vanishing = false;
        this.vanishTime = 0;
        this.updateAbilities(true);
        this.markDirty();
    }

    public boolean isFocusing() {
        return this.focusing;
    }

    public boolean isCuring() {
        return this.curing;
    }

    public boolean lockedMovement() {
        return this.focusing || this.vanishing || this.curing;
    }

    public boolean lockedInteraction() {
        return (this.isGhost() || this.focusing || this.vanishing || this.curing) && !this.player.method_68878();
    }

    public boolean shouldHideInteraction() {
        return this.isGhost() && !this.player.method_68878();
    }

    public boolean shouldFreeze() {
        return this.vanishing || this.curing;
    }

    public void updateAbilities(boolean shouldSync) {
        class_1656 abilities = this.player.method_31549();
        boolean isFlying = this.player.method_31549().field_7479;
        this.player.method_68876().method_8382(abilities);
        if (this.isGhost()) {
            abilities.field_7478 = true;
            abilities.field_7479 = isFlying;
            abilities.field_7480 = true;
            abilities.field_7476 = false;
        }
        if (shouldSync) {
            this.player.method_7355();
        }
    }

    public void resetSoul() {
        this.reloadAttributes();
        this.soul = this.getMaxSoul() / 2;
        this.soulDecay = 10;
        this.vanishing = false;
        this.vanishTime = 0;
        this.curing = false;
        this.cureTime = 0;
        this.setFocusing(false);
        this.setGhost(this.hasSolarSickness(true));
        this.player.field_7520 = 0;
        this.player.field_7510 = 0.0f;
        this.player.field_7495 = 0;
        this.player.method_7344().method_7580(20);
        this.player.method_7344().method_7581(0.0f);
        this.updateAbilities(true);
    }

    public void reloadAttributes() {
        class_6880 speed;
        class_1324 speedInstance;
        class_6880<class_1320> maxSoul;
        class_1324 maxSoulInstance;
        class_6880 hp;
        class_5131 container = this.player.method_6127();
        class_1324 hpInstance = container.method_45329(hp = class_5134.field_23716);
        if (hpInstance != null) {
            hpInstance.method_6200(HP_ATTRIBUTE_ID);
            if (this.isDemon()) {
                hpInstance.method_26835(new class_1322(HP_ATTRIBUTE_ID, -0.4, class_1322.class_1323.field_6330));
            }
        }
        if ((maxSoulInstance = container.method_45329(maxSoul = ModAttributes.MAX_SOUL)) != null) {
            maxSoulInstance.method_6200(MAX_SOUL_ATTRIBUTE_ID);
        }
        if ((speedInstance = container.method_45329(speed = class_5134.field_23719)) != null) {
            speedInstance.method_6200(SPEED_ATTRIBUTE_ID);
        }
    }

    public void clientTick() {
        int i;
        class_238 box;
        class_5819 random;
        if (this.hasSolarSickness(true)) {
            if (this.sunTicks < 15) {
                ++this.sunTicks;
            }
        } else if (this.sunTicks > 0) {
            --this.sunTicks;
        }
        if (this.isFocusing()) {
            random = this.player.method_59922();
            box = this.player.method_5829().method_1014(0.3);
            for (i = 0; i < 5; ++i) {
                this.player.method_73183().method_8406((class_2394)class_2398.field_11207.method_29140(), box.field_1323 + (double)random.method_43057() * (box.field_1320 - box.field_1323), this.player.method_23318(), box.field_1321 + (double)random.method_43057() * (box.field_1324 - box.field_1321), 0.0, (double)(random.method_43057() * 0.2f + 0.4f), 0.0);
            }
        }
        if (this.isVanishing()) {
            random = this.player.method_59922();
            box = this.player.method_5829();
            if (this.isGhost()) {
                for (i = 0; i < 10; ++i) {
                    this.player.method_73183().method_8406((class_2394)class_2398.field_11251.method_29140(), this.player.method_23317() + (double)((random.method_43057() - 0.5f) * 0.2f), box.field_1322 + (double)random.method_43057() * (box.field_1325 - box.field_1322), this.player.method_23321() + (double)((random.method_43057() - 0.5f) * 0.2f), (double)(random.method_43057() - 0.5f), (double)((random.method_43057() - 0.5f) * 0.5f), (double)(random.method_43057() - 0.5f));
                }
            } else {
                for (i = 0; i < 10; ++i) {
                    this.player.method_73183().method_8406((class_2394)class_2398.field_23190.method_29140(), this.player.method_23317() + (double)((random.method_43057() - 0.5f) * 0.2f), box.field_1322 + (double)random.method_43057() * (box.field_1325 - box.field_1322), this.player.method_23321() + (double)((random.method_43057() - 0.5f) * 0.2f), (double)((random.method_43057() - 0.5f) * 4.0f), (double)((random.method_43057() - 0.5f) * 2.0f), (double)((random.method_43057() - 0.5f) * 4.0f));
                }
            }
        }
        if (this.isCuring()) {
            random = this.player.method_59922();
            box = this.player.method_5829().method_1014(0.3);
            for (i = 0; i < 5; ++i) {
                this.player.method_73183().method_8406((class_2394)class_2398.field_11220.method_29140(), box.field_1323 + (double)random.method_43057() * (box.field_1320 - box.field_1323), this.player.method_23318(), box.field_1321 + (double)random.method_43057() * (box.field_1324 - box.field_1321), 0.0, (double)(random.method_43057() * 0.4f + 0.8f), 0.0);
            }
            if (this.cureRenderTicks < 60) {
                ++this.cureRenderTicks;
            }
        } else if (this.cureRenderTicks > 0) {
            --this.cureRenderTicks;
        }
    }

    public void serverTick() {
        if (this.shouldFreeze()) {
            this.player.field_6017 = 0.0;
        }
        if (this.isDemon()) {
            class_1702 manager;
            if (this.player.field_7495 > 0 || this.player.field_7520 > 0) {
                this.player.field_7520 = 0;
                this.player.field_7510 = 0.0f;
                this.player.field_7495 = 0;
            }
            if ((manager = this.player.method_7344()).method_7586() < 20 || manager.method_7589() > 0.0f) {
                manager.method_7581(0.0f);
                manager.method_7580(20);
            }
            if (this.focusing) {
                ++this.focusTime;
                if (this.focusTime > 0 && !this.player.method_68878()) {
                    this.addSoul(-4);
                }
                if (this.focusTime >= 20) {
                    this.player.method_6025(6.0f);
                    this.player.method_6033((float)class_3532.method_15386((float)this.player.method_6032()));
                    this.sendSoulEvent(SoulEventPayload.SoulEventType.FOCUS);
                    this.setFocusing(this.canFocus() && this.player.method_6032() < this.player.method_6063());
                } else if (this.soul <= 0 || !this.player.method_24828()) {
                    this.setFocusing(false);
                }
            }
            if (this.vanishing) {
                ++this.vanishTime;
                if (!this.player.method_68878() && !this.isGhost() && this.vanishTime > 0) {
                    this.addSoul(-2);
                }
                if (this.soul <= 0) {
                    this.vanishing = false;
                    this.vanishTime = 0;
                    this.markDirty();
                } else if (this.vanishTime >= (this.isGhost() ? 8 : 20)) {
                    this.setGhost(!this.isGhost());
                    this.sendSoulEvent(this.isGhost() ? SoulEventPayload.SoulEventType.VANISH : SoulEventPayload.SoulEventType.REAPPEAR);
                }
            }
            if (this.curing) {
                --this.cureTime;
                if (this.cureTime <= 0) {
                    this.setCuring(false, 0);
                    this.setForm(false);
                    this.player.method_6012();
                    this.player.method_6092(new class_1293(class_1294.field_5924, 140, 0));
                    this.sendSoulEvent(SoulEventPayload.SoulEventType.REVIVE);
                }
            }
            if (!this.player.method_68878()) {
                if (this.hasSolarSickness(true)) {
                    if (this.soul <= 0) {
                        if (this.shouldSetOnFire()) {
                            this.player.method_5639(8.0f);
                        }
                    } else {
                        this.addSoul(-1);
                    }
                }
                if (this.isGhost()) {
                    --this.soulDecay;
                    if (this.soulDecay <= 0) {
                        this.soulDecay = 10;
                        this.addSoul(-1);
                    }
                    if (this.soul <= 0) {
                        this.setGhost(false);
                    }
                }
            }
            if (this.soul > this.getMaxSoul() || this.soul < 0) {
                this.setSoul(this.getSoul());
            }
        }
        if (this.warningTicks > 0) {
            --this.warningTicks;
            this.markDirty();
        }
        if (this.isDirty) {
            this.isDirty = false;
            ModEntityComponents.SOUL.sync((Object)this.player);
        }
    }

    public void markDirty() {
        this.isDirty = true;
    }

    private void sendSoulEvent(SoulEventPayload.SoulEventType eventType) {
        SoulEventPayload payload = new SoulEventPayload(this.player.method_23317(), this.player.method_23318(), this.player.method_23321(), this.player.method_59922().method_43057(), eventType);
        for (class_3222 otherPlayer : PlayerLookup.around((class_3218)((class_3218)this.player.method_73183()), (class_243)this.player.method_73189(), (double)16.0)) {
            ServerPlayNetworking.send((class_3222)otherPlayer, (class_8710)payload);
        }
    }

    public void readData(class_11368 readView) {
        this.demonForm = readView.method_71433("demon_form", false);
        this.ghostMode = readView.method_71433("ghost_mode", false);
        this.soul = readView.method_71424("soul", 0);
        this.soulDecay = readView.method_71424("soul_decay", 10);
        this.focusing = readView.method_71433("focusing", false);
        this.focusTime = readView.method_71424("focus_time", 0);
        this.vanishing = readView.method_71433("vanishing", false);
        this.vanishTime = readView.method_71424("vanish_time", 0);
        this.curing = readView.method_71433("curing", false);
        this.cureTime = readView.method_71424("cure_time", 0);
        this.warningTicks = readView.method_71424("warning", 0);
    }

    public void writeData(class_11372 writeView) {
        writeView.method_71472("demon_form", this.demonForm);
        writeView.method_71472("ghost_mode", this.ghostMode);
        writeView.method_71465("soul", this.soul);
        writeView.method_71465("soul_decay", this.soulDecay);
        writeView.method_71472("focusing", this.focusing);
        writeView.method_71465("focus_time", this.focusTime);
        writeView.method_71472("vanishing", this.vanishing);
        writeView.method_71465("vanish_time", this.vanishTime);
        writeView.method_71472("curing", this.curing);
        writeView.method_71465("cure_time", this.cureTime);
        writeView.method_71465("warning", this.warningTicks);
    }

    public boolean shouldSetOnFire() {
        float f = this.player.method_5718();
        return this.hasSolarSickness(true) && this.player.method_59922().method_43057() * 30.0f < (f - 0.4f) * 2.0f;
    }

    public boolean hasSolarSickness(boolean ghostIgnoresSun) {
        if (!this.isDemon() || this.curing || this.isGhost() && ghostIgnoresSun || this.player.method_6059(class_1294.field_5918)) {
            return false;
        }
        class_2338 blockPos = class_2338.method_49637((double)this.player.method_23317(), (double)this.player.method_23320(), (double)this.player.method_23321());
        boolean bl = this.player.method_5721() || this.player.field_27857 || this.player.field_28628;
        return this.player.method_73183().method_8530() && !bl && this.player.method_73183().method_8311(blockPos);
    }

    public static SoulComponent of(class_1309 player) {
        return (SoulComponent)ModEntityComponents.SOUL.getNullable((Object)player);
    }
}

