/*
 * Decompiled with CFR 0.152.
 */
package net.eman3600.hdemise.mixin.client;

import net.eman3600.hdemise.cardinal_components.SoulComponent;
import net.eman3600.hdemise.init.ModAttributes;
import net.eman3600.hdemise.util.client.DemiseHeartType;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_9779;
import net.minecraft.class_9848;
import org.jspecify.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_329.class})
public abstract class InGameHudMixin {
    @Shadow
    @Final
    private class_5819 field_2034;
    @Shadow
    private int field_2042;
    @Unique
    private static final class_2960 HUD_ICONS = class_2960.method_60655((String)"hdemise", (String)"textures/gui/hud/icons.png");
    @Unique
    private static final class_2960 GHOST_VIGNETTE_TEXTURE = class_2960.method_60655((String)"hdemise", (String)"textures/misc/ghost_vignette.png");
    @Unique
    private static final class_2960 SOLAR_VIGNETTE_TEXTURE = class_2960.method_60655((String)"hdemise", (String)"textures/misc/solar_vignette.png");
    @Unique
    private static final class_2960 CURE_VIGNETTE_TEXTURE = class_2960.method_60655((String)"hdemise", (String)"textures/misc/cure_vignette.png");

    @Shadow
    protected abstract @Nullable class_1657 method_1737();

    @Inject(method={"method_58477"}, at={@At(value="HEAD")}, cancellable=true)
    private void hdemise$renderFood(class_332 context, class_1657 player, int top, int right, CallbackInfo ci) {
        SoulComponent sc = SoulComponent.of((class_1309)player);
        if (sc.isDemon()) {
            if (sc.isGhost()) {
                right -= 51;
            }
            int v = sc.isCuring() ? 90 : (sc.getWarning() > 0 ? 72 : (sc.isGhost() && sc.isVanishing() && sc.hasSolarSickness(false) ? 36 : (sc.isGhost() != sc.isVanishing() ? 54 : (sc.hasSolarSickness(true) ? 36 : 18))));
            int soulPerVessel = 80;
            int vessels = Math.max((int)player.method_45325(ModAttributes.MAX_SOUL), 1);
            int soul = sc.getSoul();
            for (int j = 0; j < vessels; ++j) {
                boolean leftmost;
                int l = right - j % 10 * 8 - 9;
                int k = top - j / 10 * 10;
                boolean rightmost = j % 10 == 0;
                boolean bl = leftmost = j % 10 == 9 || j == vessels - 1;
                int u = rightmost && leftmost ? 27 : (rightmost ? 18 : (leftmost ? 0 : 9));
                int fill = class_3532.method_15340((int)(soul - j * soulPerVessel), (int)0, (int)soulPerVessel);
                if (sc.getSoul() <= 0 || sc.hasSolarSickness(true)) {
                    k += this.field_2034.method_43048(3) - 1;
                } else if ((sc.isFocusing() || sc.isVanishing()) && this.field_2034.method_43048(4) == 0) {
                    k += this.field_2034.method_43048(3) - 1;
                } else if ((sc.getSoulVessels() <= 3.0f || sc.isGhost()) && this.field_2042 % (int)(sc.getSoulVessels() * (float)(sc.isGhost() ? 6 : 12) + 2.0f) == 0) {
                    k += this.field_2034.method_43048(3) - 1;
                }
                context.method_25290(class_10799.field_56883, HUD_ICONS, l, k, (float)u, (float)v, 9, 9, 256, 256);
                if (fill <= 0 && (j % 10 == 0 || soul - j * soulPerVessel < soulPerVessel)) continue;
                int pixels = 1 + (int)(8.0f * (float)fill / (float)soulPerVessel);
                context.method_25290(class_10799.field_56883, HUD_ICONS, l + (9 - pixels), k, (float)(u + (9 - pixels)), (float)(v + 9), pixels, 9, 256, 256);
            }
            ci.cancel();
        }
    }

    @Inject(method={"method_1735"}, at={@At(value="HEAD")}, cancellable=true)
    private void hdemise$renderVignetteOverlay(class_332 context, class_1297 entity, CallbackInfo ci) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            SoulComponent sc = SoulComponent.of((class_1309)player);
            if (sc.isGhost()) {
                context.method_25291(class_10799.field_56889, GHOST_VIGNETTE_TEXTURE, 0, 0, 0.0f, 0.0f, context.method_51421(), context.method_51443(), context.method_51421(), context.method_51443(), -1);
                ci.cancel();
            } else if (sc.cureRenderTicks > 0) {
                float h = (float)sc.cureRenderTicks / 60.0f;
                context.method_25291(class_10799.field_56889, CURE_VIGNETTE_TEXTURE, 0, 0, 0.0f, 0.0f, context.method_51421(), context.method_51443(), context.method_51421(), context.method_51443(), class_9848.method_61318((float)1.0f, (float)h, (float)h, (float)h));
            } else if (sc.sunTicks > 0) {
                float h = (float)sc.sunTicks / 15.0f;
                context.method_25291(class_10799.field_56889, SOLAR_VIGNETTE_TEXTURE, 0, 0, 0.0f, 0.0f, context.method_51421(), context.method_51443(), context.method_51421(), context.method_51443(), class_9848.method_61318((float)1.0f, (float)h, (float)h, (float)h));
            }
        }
    }

    @Inject(method={"method_1736"}, at={@At(value="HEAD")}, cancellable=true)
    private void hdemise$renderCrosshair(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        SoulComponent sc = SoulComponent.of((class_1309)this.method_1737());
        if (sc.shouldHideInteraction()) {
            ci.cancel();
        }
    }

    @Inject(method={"method_65022"}, at={@At(value="HEAD")}, cancellable=true)
    private void hdemise$renderAirBubbles(class_332 context, class_1657 player, int heartCount, int top, int left, CallbackInfo ci) {
        SoulComponent sc = SoulComponent.of((class_1309)this.method_1737());
        if (sc.isDemon()) {
            ci.cancel();
        }
    }

    @Inject(method={"method_1759"}, at={@At(value="HEAD")}, cancellable=true)
    private void hdemise$renderHotbar(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        SoulComponent sc = SoulComponent.of((class_1309)this.method_1737());
        if (sc.shouldHideInteraction()) {
            ci.cancel();
        }
    }

    @Inject(method={"method_70842"}, at={@At(value="RETURN")}, cancellable=true)
    private void hdemise$getCurrentBarType(CallbackInfoReturnable<class_329.class_11220> cir) {
        SoulComponent sc = SoulComponent.of((class_1309)this.method_1737());
        if (cir.getReturnValue() == class_329.class_11220.field_59820 && sc != null && sc.isDemon()) {
            cir.setReturnValue((Object)class_329.class_11220.field_59819);
        }
    }

    @Inject(method={"method_37299"}, at={@At(value="HEAD")}, cancellable=true)
    private void hdemise$drawHeart(class_332 context, class_329.class_6411 type, int x, int y, boolean hardcore, boolean blinking, boolean half, CallbackInfo ci) {
        SoulComponent sc = SoulComponent.of((class_1309)this.method_1737());
        if (sc.isGhost()) {
            ci.cancel();
        } else if (sc.isDemon() && type == class_329.class_6411.field_33945) {
            context.method_25290(class_10799.field_56883, DemiseHeartType.SOUL.getTexture(hardcore, half, blinking), x, y, 0.0f, 0.0f, 9, 9, 9, 9);
            ci.cancel();
        }
    }

    @Inject(method={"method_58478"}, at={@At(value="HEAD")}, cancellable=true)
    private static void hdemise$renderArmor(class_332 context, class_1657 player, int y, int i, int healthBarLines, int x, CallbackInfo ci) {
        SoulComponent sc = SoulComponent.of((class_1309)player);
        if (sc.isGhost()) {
            ci.cancel();
        }
    }
}

