/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mosnowgolems.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ModelAcaciaSnowGolemModel
extends EntityModel<LivingEntityRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"mosnow_golems", (String)"model_acacia_snow_golem_model"), "main");
    public final ModelPart head;
    public final ModelPart leftHand;
    public final ModelPart leftHandRotation;
    public final ModelPart rightHand;
    public final ModelPart rightHandFlip;
    public final ModelPart rightHandRotation;
    public final ModelPart bodyTop;
    public final ModelPart bodyBottom;

    public ModelAcaciaSnowGolemModel(ModelPart root) {
        super(root);
        this.head = root.getChild("head");
        this.leftHand = root.getChild("left_hand");
        this.leftHandRotation = this.leftHand.getChild("left_hand_rotation");
        this.rightHand = root.getChild("right_hand");
        this.rightHandFlip = this.rightHand.getChild("right_hand_flip");
        this.rightHandRotation = this.rightHandFlip.getChild("right_hand_rotation");
        this.bodyTop = root.getChild("body");
        this.bodyBottom = root.getChild("body_bottom");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(-0.5f)), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition leftHand = partdefinition.addOrReplaceChild("left_hand", CubeListBuilder.create(), PartPose.offset((float)4.5f, (float)5.25f, (float)0.0f));
        leftHand.addOrReplaceChild("left_hand_rotation", CubeListBuilder.create().texOffs(32, 0).addBox(-0.5f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)-0.5f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.9948f));
        PartDefinition rightHand = partdefinition.addOrReplaceChild("right_hand", CubeListBuilder.create(), PartPose.offset((float)-14.5f, (float)5.25f, (float)0.0f));
        PartDefinition rightFlip = rightHand.addOrReplaceChild("right_hand_flip", CubeListBuilder.create(), PartPose.offsetAndRotation((float)5.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)((float)Math.PI), (float)0.0f));
        rightFlip.addOrReplaceChild("right_hand_rotation", CubeListBuilder.create().texOffs(32, 0).addBox(-0.5f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)-5.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.9948f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 16).addBox(-5.0f, -10.0f, -5.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(-0.5f)), PartPose.offset((float)0.0f, (float)13.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("body_bottom", CubeListBuilder.create().texOffs(0, 36).addBox(-6.0f, -12.0f, -6.0f, 12.0f, 12.0f, 12.0f, new CubeDeformation(-0.5f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(LivingEntityRenderState state) {
        float swing;
        float limbSwing = state.walkAnimationPos;
        float limbSwingAmount = state.walkAnimationSpeed;
        float ageInTicks = state.ageInTicks;
        float netHeadYaw = state.yRot;
        float headPitch = state.xRot;
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.bodyTop.yRot = this.head.yRot * 0.25f;
        this.leftHandRotation.xRot = swing = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
        this.rightHandRotation.xRot = swing;
    }
}

