/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mosnowgolems.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ModelSculkGolem2222
extends EntityModel<LivingEntityRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"mosnow_golems", (String)"model_sculk_golem_2222"), "main");
    public final ModelPart head;
    public final ModelPart left_hand;
    public final ModelPart left_hand_rotation;
    public final ModelPart right_hand;
    public final ModelPart right_hand_flip;
    public final ModelPart right_hand_rotation;
    public final ModelPart body;
    public final ModelPart body_bottom;
    public final ModelPart left_tendril;

    public ModelSculkGolem2222(ModelPart root) {
        super(root);
        this.head = root.getChild("head");
        this.left_hand = root.getChild("left_hand");
        this.left_hand_rotation = this.left_hand.getChild("left_hand_rotation");
        this.right_hand = root.getChild("right_hand");
        this.right_hand_flip = this.right_hand.getChild("right_hand_flip");
        this.right_hand_rotation = this.right_hand_flip.getChild("right_hand_rotation");
        this.body = root.getChild("body");
        this.body_bottom = root.getChild("body_bottom");
        this.left_tendril = root.getChild("left_tendril");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(-0.5f)).texOffs(40, 12).addBox(-13.5f, -14.0f, 0.0f, 12.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition left_tendril_r1 = head.addOrReplaceChild("left_tendril_r1", CubeListBuilder.create().texOffs(40, 12).addBox(-6.0f, -5.0f, 0.0f, 12.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)7.25f, (float)-9.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition left_hand = partdefinition.addOrReplaceChild("left_hand", CubeListBuilder.create(), PartPose.offset((float)4.5f, (float)5.25f, (float)0.0f));
        PartDefinition left_hand_rotation = left_hand.addOrReplaceChild("left_hand_rotation", CubeListBuilder.create().texOffs(32, 0).addBox(-0.5f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)-0.5f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.9948f));
        PartDefinition right_hand = partdefinition.addOrReplaceChild("right_hand", CubeListBuilder.create(), PartPose.offset((float)-14.5f, (float)5.25f, (float)0.0f));
        PartDefinition right_hand_flip = right_hand.addOrReplaceChild("right_hand_flip", CubeListBuilder.create(), PartPose.offsetAndRotation((float)5.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition right_hand_rotation = right_hand_flip.addOrReplaceChild("right_hand_rotation", CubeListBuilder.create().texOffs(32, 0).addBox(-0.5f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)-5.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.9948f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 16).addBox(-5.0f, -10.0f, -5.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(-0.5f)), PartPose.offset((float)0.0f, (float)13.0f, (float)0.0f));
        PartDefinition body_bottom = partdefinition.addOrReplaceChild("body_bottom", CubeListBuilder.create().texOffs(0, 36).addBox(-6.0f, -12.0f, -6.0f, 12.0f, 12.0f, 12.0f, new CubeDeformation(-0.5f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition left_tendril = partdefinition.addOrReplaceChild("left_tendril", CubeListBuilder.create(), PartPose.offset((float)7.25f, (float)-5.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(LivingEntityRenderState state) {
        float swing;
        float limbSwing = state.walkAnimationPos;
        float limbSwingAmount = state.walkAnimationSpeed;
        float ageInTicks = state.ageInTicks;
        float netHeadYaw = state.yRot;
        float headPitch = state.xRot;
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.body.yRot = this.head.yRot * 0.25f;
        this.left_hand_rotation.xRot = swing = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
        this.right_hand_rotation.xRot = swing;
    }
}

