/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mosnowgolems.client.model;

import java.util.Random;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ModelSoulTorch_Man
extends EntityModel<LivingEntityRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"mosnow_golems", (String)"model_soul_torch_man"), "main");
    public final ModelPart head;
    public final ModelPart left_hand;
    public final ModelPart left_hand_rotation;
    public final ModelPart right_hand;
    public final ModelPart right_hand_flip;
    public final ModelPart right_hand_rotation;
    public final ModelPart body;
    public final ModelPart body_bottom;
    private final Random random = new Random();

    public ModelSoulTorch_Man(ModelPart root) {
        super(root);
        this.head = root.getChild("head");
        this.left_hand = root.getChild("left_hand");
        this.left_hand_rotation = this.left_hand.getChild("left_hand_rotation");
        this.right_hand = root.getChild("right_hand");
        this.right_hand_flip = this.right_hand.getChild("right_hand_flip");
        this.right_hand_rotation = this.right_hand_flip.getChild("right_hand_rotation");
        this.body = root.getChild("body");
        this.body_bottom = root.getChild("body_bottom");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)-0.25f, (float)11.5f, (float)0.25f));
        head.addOrReplaceChild("head_r1", CubeListBuilder.create().texOffs(24, 14).addBox(-2.25f, -2.75f, -2.25f, 5.0f, 5.0f, 5.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)0.25f, (float)0.0f, (float)0.25f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition left_hand = partdefinition.addOrReplaceChild("left_hand", CubeListBuilder.create(), PartPose.offset((float)2.25f, (float)15.125f, (float)0.0f));
        left_hand.addOrReplaceChild("left_hand_rotation", CubeListBuilder.create().texOffs(24, 24).addBox(-1.0f, -1.25f, -0.75f, 7.0f, 2.0f, 2.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)-0.25f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.9948f));
        PartDefinition right_hand = partdefinition.addOrReplaceChild("right_hand", CubeListBuilder.create(), PartPose.offset((float)-7.25f, (float)15.125f, (float)0.0f));
        PartDefinition right_hand_flip = right_hand.addOrReplaceChild("right_hand_flip", CubeListBuilder.create(), PartPose.offsetAndRotation((float)2.5f, (float)0.5f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        right_hand_flip.addOrReplaceChild("right_hand_rotation", CubeListBuilder.create().texOffs(0, 26).addBox(-1.0f, -1.25f, -0.75f, 7.0f, 2.0f, 2.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)-2.75f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.9948f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 14).addBox(-3.25f, -6.25f, -2.75f, 6.0f, 6.0f, 6.0f, new CubeDeformation(-0.5f)), PartPose.offset((float)0.0f, (float)19.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("body_bottom", CubeListBuilder.create().texOffs(0, 0).addBox(-3.75f, -6.75f, -3.25f, 7.0f, 7.0f, 7.0f, new CubeDeformation(-0.5f)), PartPose.offset((float)0.0f, (float)24.5f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(LivingEntityRenderState state) {
        float swing;
        float limbSwing = state.walkAnimationPos;
        float limbSwingAmount = state.walkAnimationSpeed;
        float ageInTicks = state.ageInTicks;
        float netHeadYaw = state.yRot;
        float headPitch = state.xRot;
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.body.yRot = this.head.yRot * 0.25f;
        this.left_hand_rotation.xRot = swing = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
        this.right_hand_rotation.xRot = swing;
    }
}

