/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mosnowgolems.procedures;

import javax.annotation.Nullable;
import net.mcreator.mosnowgolems.entity.BarrelManEntity;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber
public class BarrelManRightClickedOnEntityProcedure {
    @SubscribeEvent
    public static void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        BarrelManRightClickedOnEntityProcedure.execute((Event)event, event.getTarget(), (Entity)event.getEntity());
    }

    public static void execute(Entity entity, Entity sourceentity) {
        BarrelManRightClickedOnEntityProcedure.execute(null, entity, sourceentity);
    }

    private static void execute(@Nullable Event event, Entity entity, Entity sourceentity) {
        if (entity == null || sourceentity == null) {
            return;
        }
        Entity enetei = null;
        Entity ebb = null;
        enetei = entity;
        ebb = sourceentity;
        if (entity instanceof BarrelManEntity && sourceentity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)sourceentity;
            if (!entity.level().isClientSide()) {
                Level level = entity.level();
                RegistryAccess registryAccess = level.registryAccess();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                boolean wasOpen = (Boolean)entity.getEntityData().get(BarrelManEntity.DATA_isOpen);
                entity.getEntityData().set(BarrelManEntity.DATA_isOpen, (Object)(!wasOpen ? 1 : 0));
                if (!wasOpen) {
                    level.playSound(null, x, y, z, SoundEvents.BARREL_OPEN, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else {
                    level.playSound(null, x, y, z, SoundEvents.BARREL_CLOSE, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                if (!wasOpen) {
                    Tag nbtTag;
                    final SimpleContainer container = new SimpleContainer(27);
                    if (entity.getPersistentData().contains("_inv") && (nbtTag = entity.getPersistentData().get("_inv")) instanceof ListTag) {
                        ListTag listtag = (ListTag)nbtTag;
                        for (Tag inbt : listtag) {
                            if (!(inbt instanceof CompoundTag)) continue;
                            CompoundTag itemTag = (CompoundTag)inbt;
                            ItemStack.parse((HolderLookup.Provider)registryAccess, (Tag)itemTag).ifPresent(stack -> {
                                int slot = itemTag.getByte("Slot").orElse((byte)0) & 0xFF;
                                if (slot >= 0 && slot < container.getContainerSize()) {
                                    container.setItem(slot, stack);
                                }
                            });
                        }
                    }
                    MenuProvider menuProvider = new MenuProvider(){

                        public Component getDisplayName() {
                            return Component.translatable((String)"container.barrel");
                        }

                        public AbstractContainerMenu createMenu(int id, Inventory inv, Player p) {
                            return ChestMenu.threeRows((int)id, (Inventory)inv, (Container)container);
                        }
                    };
                    player.openMenu(menuProvider);
                    container.addListener(c -> {
                        ListTag listtag = new ListTag();
                        for (int i = 0; i < container.getContainerSize(); ++i) {
                            ItemStack stack = container.getItem(i);
                            if (stack.isEmpty()) continue;
                            CompoundTag itemTag = new CompoundTag();
                            itemTag.putByte("Slot", (byte)i);
                            listtag.add((Object)stack.save((HolderLookup.Provider)registryAccess, (Tag)itemTag));
                        }
                        entity.getPersistentData().put("_inv", (Tag)listtag);
                    });
                }
            }
        }
    }
}

