/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mosnowgolems.procedures;

import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber
public class JukeboxManOnEntityTickUpdateProcedure {
    @SubscribeEvent
    public static void onEntityTick(EntityTickEvent.Pre event) {
        JukeboxManOnEntityTickUpdateProcedure.execute((Event)event, event.getEntity());
    }

    public static void execute(Entity entity) {
        JukeboxManOnEntityTickUpdateProcedure.execute(null, entity);
    }

    private static void execute(@Nullable Event event, Entity entity) {
        if (entity == null) {
            return;
        }
        Entity local_target_entity = null;
        local_target_entity = entity;
        if (entity == null || entity.level().isClientSide()) {
            return;
        }
        Level level = entity.level();
        RegistryAccess registryAccess = level.registryAccess();
        entity.getPersistentData().getString("music_disc_id").ifPresent(discID -> {
            long songEndTime;
            if (!discID.isEmpty() && (songEndTime = entity.getPersistentData().getLong("songEndTime").orElse(0L).longValue()) > 0L && level.getGameTime() >= songEndTime) {
                BuiltInRegistries.ITEM.getOptional(ResourceLocation.tryParse((String)discID)).ifPresent(item -> {
                    ItemStack discToEject = new ItemStack((ItemLike)item);
                    ItemEntity itemEntity = new ItemEntity(level, entity.getX(), entity.getY(), entity.getZ(), discToEject);
                    itemEntity.setPickUpDelay(10);
                    level.addFreshEntity((Entity)itemEntity);
                    entity.getPersistentData().putString("music_disc_id", "");
                    entity.getPersistentData().putLong("songEndTime", 0L);
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.getPlayers(p -> p.distanceToSqr(entity) < 4096.0).forEach(p -> p.connection.send((Packet)new ClientboundStopSoundPacket(null, SoundSource.RECORDS)));
                    }
                });
            }
        });
        int displayTimer = entity.getPersistentData().getInt("textDisplayTimer").orElse(0);
        if (displayTimer > 20) {
            entity.getPersistentData().getString("music_disc_id").ifPresent(discID -> {
                if (!discID.isEmpty()) {
                    BuiltInRegistries.ITEM.getOptional(ResourceLocation.tryParse((String)discID)).ifPresent(item -> {
                        ItemStack discStack = new ItemStack((ItemLike)item);
                        JukeboxSong.fromStack((HolderLookup.Provider)registryAccess, (ItemStack)discStack).ifPresent(songHolder -> {
                            Component songDescription = ((JukeboxSong)songHolder.value()).description();
                            MutableComponent message = Component.translatable((String)"record.nowPlaying", (Object[])new Object[]{songDescription});
                            float hue = (float)(System.currentTimeMillis() % 2000L) / 2000.0f;
                            int color = Color.HSBtoRGB(hue, 1.0f, 1.0f);
                            message.setStyle(message.getStyle().withColor(TextColor.fromRgb((int)color)));
                            for (ServerPlayer p : level.getEntitiesOfClass(ServerPlayer.class, entity.getBoundingBox().inflate(64.0))) {
                                p.displayClientMessage((Component)message, true);
                            }
                        });
                    });
                }
            });
        }
        if (displayTimer > 0) {
            entity.getPersistentData().putInt("textDisplayTimer", displayTimer - 1);
        }
        if (!entity.getPersistentData().getString("music_disc_id").orElse("").isEmpty() && entity.tickCount % 40 == 0 && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double headX = entity.getX();
            double headY = entity.getY() + (double)entity.getEyeHeight();
            double headZ = entity.getZ();
            double colorValue = (double)(entity.tickCount / 40 % 24) / 24.0;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.NOTE, headX, headY, headZ, 0, colorValue, 0.0, 0.0, 1.0);
        }
    }
}

