/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mosnowgolems.procedures;

import javax.annotation.Nullable;
import net.mcreator.mosnowgolems.entity.NoteblockManEntity;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber
public class NoteblockManRightClickedOnEntityProcedure {
    @SubscribeEvent
    public static void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        NoteblockManRightClickedOnEntityProcedure.execute((Event)event, event.getTarget());
    }

    public static void execute(Entity entity) {
        NoteblockManRightClickedOnEntityProcedure.execute(null, entity);
    }

    private static void execute(@Nullable Event event, Entity entity) {
        if (entity == null) {
            return;
        }
        double current_note = 0.0;
        BlockState local_block_state_below = Blocks.AIR.defaultBlockState();
        Entity local_target_entity = null;
        local_target_entity = entity;
        if (entity == null || !(entity instanceof NoteblockManEntity) || entity.level().isClientSide()) {
            return;
        }
        String block_id_string = entity.getPersistentData().getString("block_below_id").orElse("");
        if (block_id_string.isEmpty()) {
            return;
        }
        BuiltInRegistries.BLOCK.getOptional(ResourceLocation.tryParse((String)block_id_string)).ifPresent(block -> {
            BlockState block_state_below = block.defaultBlockState();
            int currentNote = entity.getPersistentData().getInt("note").orElse(0);
            NoteBlockInstrument instrument = block_state_below.instrument();
            double headX = entity.getX();
            double headY = entity.getY() + (double)entity.getEyeHeight();
            double headZ = entity.getZ();
            entity.level().playSound(null, headX, headY, headZ, (SoundEvent)instrument.getSoundEvent().value(), SoundSource.RECORDS, 3.0f, (float)Math.pow(2.0, (double)(currentNote - 12) / 12.0));
            Level patt0$temp = entity.level();
            if (patt0$temp instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt0$temp;
                double colorValue = (double)currentNote / 24.0;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.NOTE, headX, headY, headZ, 0, colorValue, 0.0, 0.0, 1.0);
            }
            int nextNote = (currentNote + 1) % 25;
            entity.getPersistentData().putInt("note", nextNote);
        });
    }
}

