/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mosnowgolems.procedures;

import java.util.Optional;
import net.mcreator.mosnowgolems.entity.SmokerManEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SmokerManOnEntityTickUpdateProcedure {
    public static void execute(Entity entity) {
        Level level;
        if (entity == null) {
            return;
        }
        Object ebb = null;
        Entity enetei = null;
        enetei = entity;
        if (entity instanceof SmokerManEntity && (level = entity.level()) instanceof ServerLevel) {
            ItemStack output;
            RecipeHolder recipeHolder;
            ItemStack result;
            Tag nbtTag;
            ServerLevel sl = (ServerLevel)level;
            RegistryAccess registryAccess = sl.registryAccess();
            CompoundTag tag = entity.getPersistentData();
            SimpleContainer inventory = new SimpleContainer(3);
            if (tag.contains("_smoker_inv") && (nbtTag = tag.get("_smoker_inv")) instanceof ListTag) {
                ListTag listtag = (ListTag)nbtTag;
                for (Tag inbt : listtag) {
                    CompoundTag itemTag;
                    int slot;
                    if (!(inbt instanceof CompoundTag) || (slot = (itemTag = (CompoundTag)inbt).getByte("Slot").orElse((byte)0) & 0xFF) < 0 || slot >= inventory.getContainerSize()) continue;
                    ItemStack.parse((HolderLookup.Provider)registryAccess, (Tag)itemTag).ifPresent(stack -> inventory.setItem(slot, stack));
                }
            }
            int burnTime = tag.getInt("burnTime").orElse(0);
            int cookTime = tag.getInt("cookTime").orElse(0);
            int cookTimeTotal = tag.getInt("cookTimeTotal").orElse(0);
            BlockPos currentPos = new BlockPos((int)entity.getX(), (int)(entity.getY() + (double)entity.getBbHeight() * 0.5), (int)entity.getZ());
            if (burnTime > 0) {
                int particleTimer = tag.getInt("particleTimer").orElse(0);
                if (++particleTimer >= 40) {
                    particleTimer = 0;
                    sl.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, entity.getX(), entity.getY() + (double)entity.getBbHeight(), entity.getZ(), 1, 0.0, 0.0, 0.0, 0.01);
                }
                tag.putInt("particleTimer", particleTimer);
                double lastX = tag.getDouble("last_light_x").orElse(entity.getX());
                double lastY = tag.getDouble("last_light_y").orElse(entity.getY());
                double lastZ = tag.getDouble("last_light_z").orElse(entity.getZ());
                BlockPos lastPos = new BlockPos((int)lastX, (int)lastY, (int)lastZ);
                if (!currentPos.equals((Object)lastPos)) {
                    if (sl.getBlockState(lastPos).is(Blocks.LIGHT)) {
                        sl.setBlock(lastPos, Blocks.AIR.defaultBlockState(), 3);
                    }
                    if (sl.getBlockState(currentPos).is(Blocks.AIR)) {
                        lightState = (BlockState)Blocks.LIGHT.defaultBlockState().setValue((Property)LightBlock.LEVEL, (Comparable)Integer.valueOf(14));
                        sl.setBlock(currentPos, lightState, 3);
                        tag.putDouble("last_light_x", (double)currentPos.getX());
                        tag.putDouble("last_light_y", (double)currentPos.getY());
                        tag.putDouble("last_light_z", (double)currentPos.getZ());
                    }
                } else if (!sl.getBlockState(currentPos).is(Blocks.LIGHT) && sl.getBlockState(currentPos).is(Blocks.AIR)) {
                    lightState = (BlockState)Blocks.LIGHT.defaultBlockState().setValue((Property)LightBlock.LEVEL, (Comparable)Integer.valueOf(14));
                    sl.setBlock(currentPos, lightState, 3);
                }
                entity.getEntityData().set(SmokerManEntity.DATA_isOn, (Object)true);
            } else {
                if (tag.contains("last_light_x")) {
                    double lastZ;
                    double lastY;
                    double lastX = tag.getDouble("last_light_x").orElse(entity.getX());
                    BlockPos lastPos = new BlockPos((int)lastX, (int)(lastY = tag.getDouble("last_light_y").orElse(entity.getY()).doubleValue()), (int)(lastZ = tag.getDouble("last_light_z").orElse(entity.getZ()).doubleValue()));
                    if (sl.getBlockState(lastPos).is(Blocks.LIGHT)) {
                        sl.setBlock(lastPos, Blocks.AIR.defaultBlockState(), 3);
                    }
                    tag.remove("last_light_x");
                    tag.remove("last_light_y");
                    tag.remove("last_light_z");
                }
                entity.getEntityData().set(SmokerManEntity.DATA_isOn, (Object)false);
                tag.remove("particleTimer");
            }
            if (burnTime > 0) {
                --burnTime;
            }
            ItemStack fuel = inventory.getItem(1);
            ItemStack ingredient = inventory.getItem(0);
            boolean canSmelt = false;
            Optional recipeOpt = sl.getServer().getRecipeManager().getRecipeFor(RecipeType.SMOKING, (RecipeInput)new SingleRecipeInput(ingredient), (Level)sl);
            if (recipeOpt.isPresent() && !(result = ((SmokingRecipe)(recipeHolder = (RecipeHolder)recipeOpt.get()).value()).assemble(new SingleRecipeInput(ingredient), (HolderLookup.Provider)registryAccess)).isEmpty() && ((output = inventory.getItem(2)).isEmpty() || ItemStack.isSameItem((ItemStack)output, (ItemStack)result) && output.getCount() < output.getMaxStackSize())) {
                canSmelt = true;
            }
            if (burnTime == 0 && canSmelt && !fuel.isEmpty()) {
                burnTime = fuel.getBurnTime(RecipeType.SMOKING, sl.fuelValues());
                tag.putInt("burnTimeTotal", burnTime);
                if (burnTime > 0) {
                    fuel.shrink(1);
                }
            }
            if (canSmelt && burnTime > 0) {
                ++cookTime;
                if (cookTimeTotal == 0 && recipeOpt.isPresent()) {
                    cookTimeTotal = ((SmokingRecipe)((RecipeHolder)recipeOpt.get()).value()).cookingTime();
                }
                if (cookTime >= cookTimeTotal && recipeOpt.isPresent()) {
                    RecipeHolder recipeHolder2 = (RecipeHolder)recipeOpt.get();
                    ItemStack result2 = ((SmokingRecipe)recipeHolder2.value()).assemble(new SingleRecipeInput(ingredient), (HolderLookup.Provider)registryAccess);
                    output = inventory.getItem(2);
                    if (output.isEmpty()) {
                        inventory.setItem(2, result2.copy());
                    } else if (ItemStack.isSameItem((ItemStack)output, (ItemStack)result2)) {
                        output.grow(result2.getCount());
                    }
                    ingredient.shrink(1);
                    cookTime = 0;
                }
            } else {
                cookTime = 0;
            }
            tag.putInt("burnTime", burnTime);
            tag.putInt("cookTime", cookTime);
            tag.putInt("cookTimeTotal", cookTimeTotal);
            ListTag listtag = new ListTag();
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                Tag savedTag;
                ItemStack stack2 = inventory.getItem(i);
                if (stack2.isEmpty() || !((savedTag = stack2.save((HolderLookup.Provider)registryAccess)) instanceof CompoundTag)) continue;
                CompoundTag itemTag = (CompoundTag)savedTag;
                itemTag.putByte("Slot", (byte)i);
                listtag.add((Object)itemTag);
            }
            tag.put("_smoker_inv", (Tag)listtag);
        }
    }
}

