/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mosnowgolems.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ModelSnowGolemHeadOnly<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"mosnow_golems", (String)"model_snow_golem_head_only"), "main");
    public final ModelPart head;
    public final ModelPart leftHand;
    public final ModelPart leftHandRotation;
    public final ModelPart rightHand;
    public final ModelPart rightHandFlip;
    public final ModelPart rightHandRotation;
    public final ModelPart body;
    public final ModelPart bodyBottom;

    public ModelSnowGolemHeadOnly(ModelPart root) {
        this.head = root.getChild("head");
        this.leftHand = root.getChild("left_hand");
        this.leftHandRotation = this.leftHand.getChild("left_hand_rotation");
        this.rightHand = root.getChild("right_hand");
        this.rightHandFlip = this.rightHand.getChild("right_hand_flip");
        this.rightHandRotation = this.rightHandFlip.getChild("right_hand_rotation");
        this.body = root.getChild("body");
        this.bodyBottom = root.getChild("body_bottom");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(-0.5f)), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition leftHand = root.addOrReplaceChild("left_hand", CubeListBuilder.create(), PartPose.offset((float)4.5f, (float)5.25f, (float)0.0f));
        leftHand.addOrReplaceChild("left_hand_rotation", CubeListBuilder.create().texOffs(32, 0).addBox(-0.5f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)-0.5f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.9948f));
        PartDefinition rightHand = root.addOrReplaceChild("right_hand", CubeListBuilder.create(), PartPose.offset((float)-14.5f, (float)5.25f, (float)0.0f));
        PartDefinition rightFlip = rightHand.addOrReplaceChild("right_hand_flip", CubeListBuilder.create(), PartPose.offsetAndRotation((float)5.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)((float)Math.PI), (float)0.0f));
        rightFlip.addOrReplaceChild("right_hand_rotation", CubeListBuilder.create().texOffs(32, 0).addBox(-0.5f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)-5.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.9948f));
        root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 16).addBox(-5.0f, -10.0f, -5.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(-0.5f)), PartPose.offset((float)0.0f, (float)13.0f, (float)0.0f));
        root.addOrReplaceChild("body_bottom", CubeListBuilder.create().texOffs(0, 36).addBox(-6.0f, -12.0f, -6.0f, 12.0f, 12.0f, 12.0f, new CubeDeformation(-0.5f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float swing;
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.leftHandRotation.xRot = swing = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount * 0.5);
        this.rightHandRotation.xRot = swing;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int rgb) {
        this.head.render(poseStack, buffer, packedLight, packedOverlay, rgb);
        this.leftHand.render(poseStack, buffer, packedLight, packedOverlay, rgb);
        this.rightHand.render(poseStack, buffer, packedLight, packedOverlay, rgb);
        this.body.render(poseStack, buffer, packedLight, packedOverlay, rgb);
        this.bodyBottom.render(poseStack, buffer, packedLight, packedOverlay, rgb);
    }
}

