/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mosnowgolems.entity;

import net.mcreator.mosnowgolems.entity.TubeCoralProjectileEntity;
import net.mcreator.mosnowgolems.procedures.KelpManFloatProcedure;
import net.mcreator.mosnowgolems.procedures.TubeCoralManOnEntityTickUpdateProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class TubeCoralManEntity
extends PathfinderMob
implements RangedAttackMob {
    public static final EntityDataAccessor<Boolean> DATA_isDry = SynchedEntityData.defineId(TubeCoralManEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_WaterTicks = SynchedEntityData.defineId(TubeCoralManEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_FloatInWater = SynchedEntityData.defineId(TubeCoralManEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public TubeCoralManEntity(EntityType<TubeCoralManEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new MoveControl((Mob)this){

            public void tick() {
                if (TubeCoralManEntity.this.isInWater()) {
                    TubeCoralManEntity.this.setDeltaMovement(TubeCoralManEntity.this.getDeltaMovement().add(0.0, 0.005, 0.0));
                }
                if (this.operation == MoveControl.Operation.MOVE_TO && !TubeCoralManEntity.this.getNavigation().isDone()) {
                    double dx = this.wantedX - TubeCoralManEntity.this.getX();
                    double dy = this.wantedY - TubeCoralManEntity.this.getY();
                    double dz = this.wantedZ - TubeCoralManEntity.this.getZ();
                    float f = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.speedModifier * TubeCoralManEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                    TubeCoralManEntity.this.setYRot(this.rotlerp(TubeCoralManEntity.this.getYRot(), f, 10.0f));
                    TubeCoralManEntity.this.yBodyRot = TubeCoralManEntity.this.getYRot();
                    TubeCoralManEntity.this.yHeadRot = TubeCoralManEntity.this.getYRot();
                    if (TubeCoralManEntity.this.isInWater()) {
                        TubeCoralManEntity.this.setSpeed((float)TubeCoralManEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                        float f2 = -((float)(Mth.atan2((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        TubeCoralManEntity.this.setXRot(this.rotlerp(TubeCoralManEntity.this.getXRot(), f2, 5.0f));
                        float f3 = Mth.cos((float)(TubeCoralManEntity.this.getXRot() * ((float)Math.PI / 180)));
                        TubeCoralManEntity.this.setZza(f3 * f1);
                        TubeCoralManEntity.this.setYya((float)((double)f1 * dy));
                    } else {
                        TubeCoralManEntity.this.setSpeed(f1 * 0.05f);
                    }
                } else {
                    TubeCoralManEntity.this.setSpeed(0.0f);
                    TubeCoralManEntity.this.setYya(0.0f);
                    TubeCoralManEntity.this.setZza(0.0f);
                }
            }
        };
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_isDry, (Object)false);
        builder.define(DATA_WaterTicks, (Object)0);
        builder.define(DATA_FloatInWater, (Object)false);
    }

    protected PathNavigation createNavigation(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 40));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, true, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Slime.class, true, true));
        this.targetSelector.addGoal(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(7, (Goal)new LeapAtTargetGoal((Mob)this, 0.5f));
        this.goalSelector.addGoal(8, (Goal)new FloatGoal((Mob)this){

            public boolean canUse() {
                double x = TubeCoralManEntity.this.getX();
                double y = TubeCoralManEntity.this.getY();
                double z = TubeCoralManEntity.this.getZ();
                TubeCoralManEntity entity = TubeCoralManEntity.this;
                Level world = TubeCoralManEntity.this.level();
                return super.canUse() && KelpManFloatProcedure.execute();
            }
        });
        this.goalSelector.addGoal(9, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(1, (Goal)new RangedAttackGoal(this, this, 1.25, 20, 15.0f){

            public boolean canContinueToUse() {
                return this.canUse();
            }
        });
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource source, boolean recentlyHitIn) {
        super.dropCustomDeathLoot(serverLevel, source, recentlyHitIn);
        this.spawnAtLocation(new ItemStack((ItemLike)Blocks.TUBE_CORAL));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.coral_block.hit"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.coral_block.break"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        if (damagesource.is(DamageTypes.TRIDENT)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("DataisDry", ((Boolean)this.entityData.get(DATA_isDry)).booleanValue());
        compound.putInt("DataWaterTicks", ((Integer)this.entityData.get(DATA_WaterTicks)).intValue());
        compound.putBoolean("DataFloatInWater", ((Boolean)this.entityData.get(DATA_FloatInWater)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DataisDry")) {
            this.entityData.set(DATA_isDry, (Object)compound.getBoolean("DataisDry"));
        }
        if (compound.contains("DataWaterTicks")) {
            this.entityData.set(DATA_WaterTicks, (Object)compound.getInt("DataWaterTicks"));
        }
        if (compound.contains("DataFloatInWater")) {
            this.entityData.set(DATA_FloatInWater, (Object)compound.getBoolean("DataFloatInWater"));
        }
    }

    public void baseTick() {
        super.baseTick();
        TubeCoralManOnEntityTickUpdateProcedure.execute((Entity)this);
    }

    public void performRangedAttack(LivingEntity target, float flval) {
        TubeCoralProjectileEntity.shoot((LivingEntity)this, target);
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        TubeCoralManEntity entity = this;
        return false;
    }

    public boolean isPushedByFluid() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        TubeCoralManEntity entity = this;
        return false;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.2);
        builder = builder.add(Attributes.MAX_HEALTH, 9.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 0.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(NeoForgeMod.SWIM_SPEED, 0.2);
        return builder;
    }
}

