/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mosnowgolems.procedures;

import java.util.Optional;
import net.mcreator.mosnowgolems.entity.BlastFurnaceManEntity;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;

public class BlastFurnaceManOnEntityTickUpdateProcedure {
    public static void execute(Entity entity) {
        Level level;
        if (entity == null) {
            return;
        }
        Entity enetei = null;
        enetei = entity;
        if (entity instanceof BlastFurnaceManEntity && (level = entity.level()) instanceof ServerLevel) {
            boolean isCurrentlyBurning;
            boolean isBurning;
            ItemStack output;
            ItemStack result;
            ServerLevel sl = (ServerLevel)level;
            RegistryAccess registryAccess = sl.registryAccess();
            CompoundTag tag = entity.getPersistentData();
            NonNullList inventory = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);
            if (tag.contains("_blast_inv", 9)) {
                ListTag list = tag.getList("_blast_inv", 10);
                for (int i = 0; i < list.size(); ++i) {
                    CompoundTag itemTag = list.getCompound(i);
                    byte slot = itemTag.getByte("Slot");
                    if (slot < 0 || slot >= inventory.size()) continue;
                    inventory.set((int)slot, (Object)ItemStack.parse((HolderLookup.Provider)registryAccess, (Tag)itemTag).orElse(ItemStack.EMPTY));
                }
            }
            int burnTime = tag.getInt("burnTime");
            int cookTime = tag.getInt("cookTime");
            int cookTimeTotal = tag.getInt("cookTimeTotal");
            Optional recipeOpt = sl.getRecipeManager().getRecipeFor(RecipeType.BLASTING, (RecipeInput)new SingleRecipeInput((ItemStack)inventory.get(0)), (Level)sl);
            boolean canSmelt = false;
            if (recipeOpt.isPresent() && !(result = ((BlastingRecipe)((RecipeHolder)recipeOpt.get()).value()).getResultItem((HolderLookup.Provider)registryAccess)).isEmpty() && ((output = (ItemStack)inventory.get(2)).isEmpty() || ItemStack.matches((ItemStack)output, (ItemStack)result) && output.getCount() + result.getCount() <= output.getMaxStackSize())) {
                canSmelt = true;
                cookTimeTotal = ((BlastingRecipe)((RecipeHolder)recipeOpt.get()).value()).getCookingTime();
            }
            boolean bl = isBurning = burnTime > 0;
            if (isBurning) {
                --burnTime;
            } else if (canSmelt && !((ItemStack)inventory.get(1)).isEmpty()) {
                ItemStack fuel = (ItemStack)inventory.get(1);
                int fuelValue = AbstractFurnaceBlockEntity.getFuel().getOrDefault(fuel.getItem(), 0);
                if (fuelValue > 0) {
                    burnTime = fuelValue;
                    tag.putInt("burnTimeTotal", burnTime);
                    fuel.shrink(1);
                }
            }
            if (burnTime > 0 && canSmelt) {
                if (++cookTime >= cookTimeTotal) {
                    cookTime = 0;
                    ((ItemStack)inventory.get(0)).shrink(1);
                    ItemStack result2 = ((BlastingRecipe)((RecipeHolder)recipeOpt.get()).value()).getResultItem((HolderLookup.Provider)registryAccess);
                    ItemStack output2 = (ItemStack)inventory.get(2);
                    if (output2.isEmpty()) {
                        inventory.set(2, (Object)result2.copy());
                    } else {
                        output2.grow(result2.getCount());
                    }
                }
            } else {
                cookTime = 0;
            }
            tag.putInt("burnTime", burnTime);
            tag.putInt("cookTime", cookTime);
            tag.putInt("cookTimeTotal", cookTimeTotal);
            ListTag saveList = new ListTag();
            for (int i = 0; i < inventory.size(); ++i) {
                ItemStack stack = (ItemStack)inventory.get(i);
                if (stack.isEmpty()) continue;
                CompoundTag itemTag = new CompoundTag();
                itemTag.putByte("Slot", (byte)i);
                saveList.add((Object)stack.save((HolderLookup.Provider)registryAccess, (Tag)itemTag));
            }
            tag.put("_blast_inv", (Tag)saveList);
            boolean bl2 = isCurrentlyBurning = burnTime > 0;
            if (entity instanceof BlastFurnaceManEntity) {
                BlastFurnaceManEntity blastFurnaceEnt = (BlastFurnaceManEntity)entity;
                blastFurnaceEnt.getEntityData().set(BlastFurnaceManEntity.DATA_isOn, (Object)isCurrentlyBurning);
            }
            if (isCurrentlyBurning && sl.random.nextInt(8) == 0) {
                double particleX = entity.getX();
                double particleY = entity.getY() + (double)entity.getBbHeight() * 0.5;
                double particleZ = entity.getZ();
                sl.sendParticles((ParticleOptions)ParticleTypes.DRIPPING_LAVA, particleX, particleY, particleZ, 1, 0.2, 0.3, 0.2, 0.0);
            }
        }
    }
}

